@extends('layouts.master')

@section('title', trans('messages.profit_loss_report'))

@section('content')
<div class="page-header">
    <h2>{{ trans('messages.profit_loss_report') }}</h2>
    <div>
        <a href="{{ route('reports.profit-loss.print', request()->all()) }}" target="_blank" class="btn btn-primary">
            <i class="bi bi-printer"></i> {{ trans('messages.print_report') }}
        </a>
        <a href="{{ route('reports.index') }}" class="btn btn-secondary">
            <i class="bi bi-arrow-left"></i> {{ trans('messages.back') }}
        </a>
    </div>
</div>

<div class="card mb-3">
    <div class="card-body">
        <form method="GET" action="{{ route('reports.profit-loss') }}">
            <div class="row g-3">
                <div class="col-md-4">
                    <label for="date_from" class="form-label">{{ trans('messages.from_date') }}</label>
                    <input type="date" name="date_from" class="form-control" value="{{ $dateFrom }}">
                </div>
                <div class="col-md-4">
                    <label for="date_to" class="form-label">{{ trans('messages.to_date') }}</label>
                    <input type="date" name="date_to" class="form-control" value="{{ $dateTo }}">
                </div>
                <div class="col-md-4">
                    <label class="form-label">&nbsp;</label>
                    <button type="submit" class="btn btn-primary w-100 d-block">{{ trans('messages.filter') }}</button>
                </div>
            </div>
        </form>
    </div>
</div>

<div class="row g-3 mb-4">
    <div class="col-md-6">
        <div class="card">
            <div class="card-header bg-primary text-white">
                <h5 class="mb-0">{{ trans('messages.revenue') }}</h5>
            </div>
            <div class="card-body">
                <h3>{{ format_currency($revenue) }}</h3>
            </div>
        </div>
    </div>
    <div class="col-md-6">
        <div class="card">
            <div class="card-header bg-danger text-white">
                <h5 class="mb-0">{{ trans('messages.cost_of_goods_sold') }}</h5>
            </div>
            <div class="card-body">
                <h3>{{ format_currency($cogs) }}</h3>
            </div>
        </div>
    </div>
    <div class="col-md-6">
        <div class="card">
            <div class="card-header bg-success text-white">
                <h5 class="mb-0">{{ trans('messages.gross_profit') }}</h5>
            </div>
            <div class="card-body">
                <h3>{{ format_currency($grossProfit) }}</h3>
                <small>{{ number_format($grossProfitMargin, 2) }}% {{ trans('messages.gross_profit_margin') }}</small>
            </div>
        </div>
    </div>
    <div class="col-md-6">
        <div class="card">
            <div class="card-header bg-warning text-dark">
                <h5 class="mb-0">{{ trans('messages.operating_expenses') }}</h5>
            </div>
            <div class="card-body">
                <h3>{{ format_currency($operatingExpenses) }}</h3>
            </div>
        </div>
    </div>
    <div class="col-md-12">
        <div class="card {{ $netProfit >= 0 ? 'border-success' : 'border-danger' }}">
            <div class="card-header {{ $netProfit >= 0 ? 'bg-success' : 'bg-danger' }} text-white">
                <h5 class="mb-0">{{ trans('messages.net_profit') }}</h5>
            </div>
            <div class="card-body">
                <h2>{{ format_currency($netProfit) }}</h2>
                <small>{{ number_format($netProfitMargin, 2) }}% {{ trans('messages.net_profit_margin') }}</small>
            </div>
        </div>
    </div>
</div>

@include('reports.partials.print-styles', ['reportTitle' => trans('messages.profit_loss_report')])
@endsection

