@extends('layouts.master')

@section('title', trans('messages.sales_report_title'))

@section('content')
<div class="page-header">
    <h2>{{ trans('messages.sales_report_title') }}</h2>
    <div>
        <button onclick="window.print()" class="btn btn-primary">
            <i class="bi bi-printer"></i> {{ trans('messages.print_report') }}
        </button>
        <a href="{{ route('reports.sales.export', request()->all()) }}" class="btn btn-success"><i class="bi bi-file-earmark-excel"></i> {{ trans('messages.export_excel') }}</a>
        <a href="{{ route('reports.sales.export_pdf', request()->all()) }}" target="_blank" class="btn btn-danger"><i class="bi bi-file-earmark-pdf"></i> {{ trans('messages.export_pdf') }}</a>
        <a href="{{ route('reports.index') }}" class="btn btn-secondary">
            <i class="bi bi-arrow-left"></i> {{ trans('messages.back') }}
        </a>
    </div>
</div>

<div class="card mb-3">
    <div class="card-body">
        <form method="GET" action="{{ route('reports.sales') }}">
            <div class="row g-3">
                <div class="col-md-3">
                    <label for="date_from" class="form-label">{{ trans('messages.from_date') }}</label>
                    <input type="date" name="date_from" class="form-control" value="{{ request('date_from', now()->startOfMonth()->format('Y-m-d')) }}">
                </div>
                <div class="col-md-3">
                    <label for="date_to" class="form-label">{{ trans('messages.to_date') }}</label>
                    <input type="date" name="date_to" class="form-control" value="{{ request('date_to', now()->endOfMonth()->format('Y-m-d')) }}">
                </div>
                <div class="col-md-3">
                    <label for="status" class="form-label">{{ trans('messages.status') }}</label>
                    <select name="status" class="form-select">
                        <option value="">{{ trans('messages.all_status') }}</option>
                        <option value="draft" {{ request('status') == 'draft' ? 'selected' : '' }}>{{ trans('messages.draft') }}</option>
                        <option value="final" {{ request('status') == 'final' ? 'selected' : '' }}>{{ trans('messages.final') }}</option>
                        <option value="paid" {{ request('status') == 'paid' ? 'selected' : '' }}>{{ trans('messages.paid') }}</option>
                        <option value="partially_paid" {{ request('status') == 'partially_paid' ? 'selected' : '' }}>{{ trans('messages.partially_paid') }}</option>
                        <option value="returned" {{ request('status') == 'returned' ? 'selected' : '' }}>{{ trans('messages.returned') }}</option>
                    </select>
                </div>
                <div class="col-md-3">
                    <label class="form-label">&nbsp;</label>
                    <button type="submit" class="btn btn-secondary w-100 d-block">{{ trans('messages.filter') }}</button>
                </div>
            </div>
        </form>
    </div>
</div>

<div class="row g-3 mb-4">
    <div class="col-md-3">
        <div class="card text-white bg-primary">
            <div class="card-body">
                <h5>{{ trans('messages.total_sales') }}</h5>
                <h3>{{ format_currency($totalSales) }}</h3>
            </div>
        </div>
    </div>
    <div class="col-md-3">
        <div class="card text-white bg-success">
            <div class="card-body">
                <h5>{{ trans('messages.paid_amount') }}</h5>
                <h3>{{ format_currency($totalPaid) }}</h3>
            </div>
        </div>
    </div>
    <div class="col-md-3">
        <div class="card text-white bg-warning">
            <div class="card-body">
                <h5>{{ trans('messages.due_amount') }}</h5>
                <h3>{{ format_currency($totalDue) }}</h3>
            </div>
        </div>
    </div>
    <div class="col-md-3">
        <div class="card text-white bg-info">
            <div class="card-body">
                <h5>{{ trans('messages.total_profit') }}</h5>
                <h3>{{ format_currency($totalProfit) }}</h3>
            </div>
        </div>
    </div>
</div>

<div class="card">
    <div class="card-body">
        <div class="table-responsive">
            <table class="table">
                <thead>
                    <tr>
                        <th>{{ trans('messages.invoice_number') }}</th>
                        <th>{{ trans('messages.date') }}</th>
                        <th>{{ trans('messages.customer') }}</th>
                        <th class="text-end">{{ trans('messages.total') }}</th>
                        <th class="text-end">{{ trans('messages.paid_amount') }}</th>
                        <th class="text-end">{{ trans('messages.due_amount') }}</th>
                        <th class="text-end">{{ trans('messages.profit') }}</th>
                        <th>{{ trans('messages.status') }}</th>
                    </tr>
                </thead>
                <tbody>
                    @forelse($invoices as $invoice)
                    <tr class="{{ $invoice->status === 'returned' ? 'table-danger' : '' }}">
                        <td><a href="{{ route('invoices.show', $invoice) }}">{{ $invoice->invoice_number }}</a></td>
                        <td>{{ $invoice->created_at->format('Y-m-d') }}</td>
                        <td>{{ $invoice->customer?->name ?? $invoice->customer_name }}</td>
                        <td class="text-end">{{ format_currency($invoice->total) }}</td>
                        <td class="text-end">{{ format_currency($invoice->paid_amount) }}</td>
                        <td class="text-end">{{ format_currency($invoice->due_amount) }}</td>
                        <td>
                            @php
                                $profit = $invoice->items->sum(function ($item) {
                                    $revenue = $item->total;
                                    $cost = $item->quantity * ($item->product->purchase_price ?? 0);
                                    return $revenue - $cost;
                                });
                            @endphp
                            <strong>{{ format_currency($profit) }}</strong>
                        </td>
                        <td>
                            @php
                                $badgeClass = match($invoice->status) {
                                    'paid' => 'success',
                                    'partially_paid' => 'warning',
                                    'draft' => 'secondary',
                                    'returned' => 'danger',
                                    default => 'info'
                                };
                            @endphp
                            <span class="badge bg-{{ $badgeClass }}">{{ trans('messages.' . $invoice->status) }}</span>
                        </td>
                    </tr>
                    @empty
                    <tr>
                        <td colspan="8" class="text-center">{{ trans('messages.no_invoices_found') }}</td>
                    </tr>
                    @endforelse
                </tbody>
            </table>
        </div>
        @if(method_exists($invoices, 'links'))
            <div class="card-footer">
                {{ $invoices->links() }}
            </div>
        @endif
    </div>
</div>

@include('reports.partials.print-styles', ['reportTitle' => trans('messages.sales_report_title')])
@endsection
