@php
    $storeName = \App\Models\Setting::get('store_name', 'Gestock Pro');
    $storeLogo = \App\Models\Setting::get('store_logo');
    $currency = currency_symbol();
    $locale = app()->getLocale();
    $isRTL = $locale === 'ar';
    $dir = $isRTL ? 'rtl' : 'ltr';
    $dateFrom = $request->filled('date_from') ? $request->date_from : now()->startOfMonth()->format('Y-m-d');
    $dateTo = $request->filled('date_to') ? $request->date_to : now()->endOfMonth()->format('Y-m-d');
    $statusFilter = $request->filled('status') ? $request->status : trans('messages.all_status');
@endphp
<!DOCTYPE html>
<html lang="{{ $locale }}" dir="{{ $dir }}">
<head>
    <meta charset="UTF-8">
    <meta name="viewport" content="width=device-width, initial-scale=1.0">
    <title>{{ trans('messages.sales_report_title') }}</title>
    <link rel="stylesheet" href="{{ asset('lib/fonts/google-fonts.css') }}">
    <style>
        @charset "UTF-8";
        
        * {
            margin: 0;
            padding: 0;
            box-sizing: border-box;
        }
        
        body {
            font-family: {{ $isRTL ? "'Cairo', 'DejaVu Sans', sans-serif" : "'Cabin', 'DejaVu Sans', sans-serif" }};
            direction: {{ $dir }};
            font-size: 14px;
            color: #333;
            padding: 20px;
            background-color: #fff;
            unicode-bidi: embed;
        }
        
        @if($isRTL)
        * {
            font-family: 'Cairo', 'DejaVu Sans', sans-serif !important;
        }
        @else
        * {
            font-family: 'Cabin', 'DejaVu Sans', sans-serif !important;
        }
        @endif
        
        .header {
            display: flex;
            justify-content: space-between;
            align-items: center;
            margin-bottom: 30px;
            border-bottom: 2px solid #333;
            padding-bottom: 20px;
        }
        
        .logo-container {
            {{ $isRTL ? 'text-align: right;' : 'text-align: left;' }}
        }
        
        .logo-container img {
            max-height: 80px;
            max-width: 200px;
        }
        
        .report-info {
            {{ $isRTL ? 'text-align: left;' : 'text-align: right;' }}
        }
        
        .report-info h2 {
            margin-bottom: 10px;
            color: #333;
            font-size: 24px;
        }
        
        .report-info p {
            margin: 5px 0;
            font-size: 14px;
            color: #666;
        }
        
        .summary {
            display: flex;
            justify-content: space-around;
            margin-bottom: 30px;
            padding: 20px;
            background-color: #f8f9fa;
            border-radius: 5px;
        }
        
        .summary-item {
            text-align: center;
        }
        
        .summary-item h4 {
            font-size: 14px;
            color: #666;
            margin-bottom: 10px;
        }
        
        .summary-item .value {
            font-size: 20px;
            font-weight: bold;
            color: #333;
        }
        
        table {
            width: 100%;
            border-collapse: collapse;
            margin-bottom: 30px;
        }
        
        thead {
            background-color: #343a40;
            color: white;
        }
        
        th, td {
            padding: 12px;
            text-align: {{ $isRTL ? 'right' : 'left' }};
            border: 1px solid #dee2e6;
        }
        
        th {
            font-weight: bold;
            font-size: 14px;
        }
        
        td {
            font-size: 13px;
        }
        
        tbody tr:nth-child(even) {
            background-color: #f8f9fa;
        }
        
        tbody tr.returned {
            background-color: #f8d7da;
        }
        
        .text-right {
            text-align: {{ $isRTL ? 'left' : 'right' }};
        }
        
        .text-center {
            text-align: center;
        }
        
        .badge {
            padding: 5px 10px;
            border-radius: 4px;
            font-size: 12px;
            font-weight: bold;
        }
        
        .badge-success {
            background-color: #28a745;
            color: white;
        }
        
        .badge-warning {
            background-color: #ffc107;
            color: #333;
        }
        
        .badge-danger {
            background-color: #dc3545;
            color: white;
        }
        
        .badge-info {
            background-color: #17a2b8;
            color: white;
        }
        
        .badge-secondary {
            background-color: #6c757d;
            color: white;
        }
        
        .print-actions {
            margin-bottom: 20px;
            text-align: center;
        }
        
        .print-actions button {
            padding: 10px 20px;
            font-size: 16px;
            background-color: #0d6efd;
            color: white;
            border: none;
            border-radius: 5px;
            cursor: pointer;
            margin: 0 10px;
        }
        
        .print-actions button:hover {
            background-color: #0b5ed7;
        }
        
        @media print {
            .print-actions {
                display: none;
            }
            
            @page {
                size: landscape;
                margin: 10mm;
            }
            
            body {
                padding: 0;
            }
        }
    </style>
</head>
<body>
    <div class="print-actions">
        <button onclick="window.print()" class="btn btn-primary">
            <i class="bi bi-printer"></i> {{ trans('messages.print') }}
        </button>
        <button onclick="window.close()" class="btn btn-secondary" style="margin-{{ $isRTL ? 'right' : 'left' }}: 10px;">
            <i class="bi bi-x-circle"></i> {{ trans('messages.close') }}
        </button>
    </div>

    <div class="header">
        <div class="logo-container">
            @if($storeLogo)
                <img src="{{ storage_url( $storeLogo) }}" alt="{{ $storeName }}">
            @else
                <h2>{{ $storeName }}</h2>
            @endif
        </div>
        <div class="report-info">
            <h2>{{ trans('messages.sales_report_title') }}</h2>
            <p>{{ trans('messages.from_date') }}: {{ $dateFrom }}</p>
            <p>{{ trans('messages.to_date') }}: {{ $dateTo }}</p>
            <p>{{ trans('messages.status') }}: {{ is_string($statusFilter) ? $statusFilter : trans('messages.' . $statusFilter) }}</p>
            <p>{{ trans('messages.date') }}: {{ now()->format('Y-m-d H:i') }}</p>
        </div>
    </div>

    <div class="summary">
        <div class="summary-item">
            <h4>{{ trans('messages.total_sales') }}</h4>
            <div class="value">{{ format_currency($totalSales) }}</div>
        </div>
        <div class="summary-item">
            <h4>{{ trans('messages.total') }} {{ trans('messages.paid') }}</h4>
            <div class="value">{{ format_currency($totalPaid) }}</div>
        </div>
        <div class="summary-item">
            <h4>{{ trans('messages.total') }} {{ trans('messages.due') }}</h4>
            <div class="value">{{ format_currency($totalDue) }}</div>
        </div>
        <div class="summary-item">
            <h4>{{ trans('messages.total_profit') }}</h4>
            <div class="value">{{ format_currency($totalProfit) }}</div>
        </div>
    </div>

    <table>
        <thead>
            <tr>
                <th>{{ trans('messages.invoice_number') }}</th>
                <th>{{ trans('messages.date') }}</th>
                <th>{{ trans('messages.customer') }}</th>
                <th class="text-right">{{ trans('messages.total') }}</th>
                <th class="text-right">{{ trans('messages.paid') }}</th>
                <th class="text-right">{{ trans('messages.due') }}</th>
                <th class="text-right">{{ trans('messages.profit') }}</th>
                <th>{{ trans('messages.status') }}</th>
            </tr>
        </thead>
        <tbody>
            @forelse($invoices as $invoice)
            <tr class="{{ $invoice->status === 'returned' ? 'returned' : '' }}">
                <td>{{ $invoice->invoice_number }}</td>
                <td>{{ $invoice->created_at->format('Y-m-d') }}</td>
                <td>{{ $invoice->customer?->name ?? $invoice->customer_name }}</td>
                <td class="text-right">{{ format_currency($invoice->total) }}</td>
                <td class="text-right">{{ format_currency($invoice->paid_amount) }}</td>
                <td class="text-right">{{ format_currency($invoice->due_amount) }}</td>
                <td class="text-right">{{ format_currency($invoice->profit) }}</td>
                <td>
                    @php
                        $badgeClass = match($invoice->status) {
                            'paid' => 'success',
                            'partially_paid' => 'warning',
                            'draft' => 'secondary',
                            'returned' => 'danger',
                            default => 'info'
                        };
                    @endphp
                    <span class="badge badge-{{ $badgeClass }}">{{ trans('messages.' . $invoice->status) }}</span>
                </td>
            </tr>
            @empty
            <tr>
                <td colspan="8" class="text-center">{{ trans('messages.no_invoices_found') }}</td>
            </tr>
            @endforelse
        </tbody>
    </table>
</body>
</html>

