@extends('layouts.master')

@section('title', trans('messages.stagnant_products_report'))

@section('content')
<div class="page-header">
    <h2>{{ trans('messages.stagnant_products_report') }}</h2>
    <div>
        <button onclick="window.print()" class="btn btn-primary">
            <i class="bi bi-printer"></i> {{ trans('messages.print_report') }}
        </button>
        <a href="{{ route('reports.index') }}" class="btn btn-secondary">
            <i class="bi bi-arrow-left"></i> {{ trans('messages.back') }}
        </a>
    </div>
</div>

<div class="card mb-3">
    <div class="card-body">
        <form method="GET" action="{{ route('reports.stagnant-products') }}">
            <div class="row g-3">
                <div class="col-md-3">
                    <label for="days" class="form-label">{{ trans('messages.not_sold_in_days') }}</label>
                    <input type="number" name="days" class="form-control" value="{{ $days }}" min="1">
                </div>
                <div class="col-md-3">
                    <label for="date_from" class="form-label">{{ trans('messages.from_date') }}</label>
                    <input type="date" name="date_from" class="form-control" value="{{ $dateFrom }}">
                </div>
                <div class="col-md-3">
                    <label for="date_to" class="form-label">{{ trans('messages.to_date') }}</label>
                    <input type="date" name="date_to" class="form-control" value="{{ $dateTo }}">
                </div>
                <div class="col-md-3">
                    <label class="form-label">&nbsp;</label>
                    <button type="submit" class="btn btn-primary w-100 d-block">{{ trans('messages.filter') }}</button>
                </div>
            </div>
        </form>
    </div>
</div>

<div class="row g-3 mb-4">
    <div class="col-md-12">
        <div class="card text-white bg-warning">
            <div class="card-body">
                <h5>{{ trans('messages.total_value') }}</h5>
                <h3>{{ format_currency($totalValue) }}</h3>
                <small>{{ $stagnantProductsPaginator->total() }} {{ trans('messages.products') }}</small>
            </div>
        </div>
    </div>
</div>

<div class="card">
    <div class="card-header">
        <h5 class="mb-0">{{ trans('messages.stagnant_products') }}</h5>
    </div>
    <div class="card-body">
        <div class="table-responsive">
            <table class="table table-striped">
                <thead>
                    <tr>
                        <th>{{ trans('messages.product') }}</th>
                        <th>{{ trans('messages.category') }}</th>
                        <th class="text-end">{{ trans('messages.stock_quantity') }}</th>
                        <th class="text-end">{{ trans('messages.purchase_price') }}</th>
                        <th class="text-end">{{ trans('messages.selling_price') }}</th>
                        <th class="text-end">{{ trans('messages.total_value') }}</th>
                    </tr>
                </thead>
                <tbody>
                    @forelse($stagnantProductsPaginator as $product)
                    <tr>
                        <td>
                            <a href="{{ route('products.show', $product->id) }}">
                                {{ $product->name }}
                            </a>
                        </td>
                        <td>{{ $product->category->name ?? '-' }}</td>
                        <td class="text-end">{{ $product->stock_quantity }}</td>
                        <td class="text-end">{{ format_currency($product->purchase_price) }}</td>
                        <td class="text-end">{{ format_currency($product->selling_price) }}</td>
                        <td class="text-end">{{ format_currency($product->stock_quantity * $product->purchase_price) }}</td>
                    </tr>
                    @empty
                    <tr>
                        <td colspan="6" class="text-center">{{ trans('messages.no_data') }}</td>
                    </tr>
                    @endforelse
                </tbody>
            </table>
        </div>
        <div class="mt-3">
            {{ $stagnantProductsPaginator->links() }}
        </div>
    </div>
</div>

@include('reports.partials.print-styles', ['reportTitle' => trans('messages.stagnant_products_report')])
@endsection

