@extends('layouts.master')

@section('title', trans('messages.warehouses_report'))

@section('content')
<div class="page-header">
    <h2>{{ trans('messages.warehouses_report') }}</h2>
    <div>
        <button onclick="window.print()" class="btn btn-primary">
            <i class="bi bi-printer"></i> {{ trans('messages.print_report') }}
        </button>
        <a href="{{ route('reports.index') }}" class="btn btn-secondary">
            <i class="bi bi-arrow-left"></i> {{ trans('messages.back') }}
        </a>
    </div>
</div>

<!-- Statistics Cards -->
<div class="row g-3 mb-4">
    <div class="col-md-3">
        <div class="card text-white bg-primary">
            <div class="card-body">
                <h5>{{ trans('messages.total_warehouses') }}</h5>
                <h3>{{ $totalWarehouses }}</h3>
            </div>
        </div>
    </div>
    <div class="col-md-3">
        <div class="card text-white bg-success">
            <div class="card-body">
                <h5>{{ trans('messages.active_warehouses') }}</h5>
                <h3>{{ $activeWarehouses }}</h3>
            </div>
        </div>
    </div>
    <div class="col-md-3">
        <div class="card text-white bg-info">
            <div class="card-body">
                <h5>{{ trans('messages.total_stock_value') }}</h5>
                <h3>{{ format_currency($totalStockValue) }}</h3>
            </div>
        </div>
    </div>
    <div class="col-md-3">
        <div class="card text-white bg-warning">
            <div class="card-body">
                <h5>{{ trans('messages.total_products') }}</h5>
                <h3>{{ $totalProducts }}</h3>
            </div>
        </div>
    </div>
</div>

<!-- Default Warehouse Info -->
@if($defaultWarehouse)
<div class="card mb-4 border-primary">
    <div class="card-header bg-primary text-white">
        <h5 class="mb-0">
            <i class="bi bi-star-fill"></i> {{ trans('messages.default_warehouse') }}
        </h5>
    </div>
    <div class="card-body">
        <div class="row">
            <div class="col-md-6">
                <p><strong>{{ trans('messages.warehouse') }}:</strong> 
                    {{ app()->getLocale() === 'ar' && $defaultWarehouse->name_ar ? $defaultWarehouse->name_ar : $defaultWarehouse->name }}
                </p>
                @if($defaultWarehouse->code)
                    <p><strong>{{ trans('messages.warehouse_code') }}:</strong> {{ $defaultWarehouse->code }}</p>
                @endif
            </div>
            <div class="col-md-6">
                <p><strong>{{ trans('messages.stock_value') }}:</strong> {{ format_currency($defaultWarehouse->total_stock_value) }}</p>
                <p><strong>{{ trans('messages.products_count') }}:</strong> {{ $defaultWarehouse->total_products_count }}</p>
            </div>
        </div>
    </div>
</div>
@endif

<!-- Warehouses Table -->
<div class="card">
    <div class="card-header">
        <h5 class="mb-0">{{ trans('messages.warehouses') }}</h5>
    </div>
    <div class="card-body">
        <div class="table-responsive">
            <table class="table table-hover">
                <thead>
                    <tr>
                        <th>{{ trans('messages.warehouse') }}</th>
                        <th>{{ trans('messages.warehouse_code') }}</th>
                        <th class="text-center">{{ trans('messages.status') }}</th>
                        <th class="text-end">{{ trans('messages.products_count') }}</th>
                        <th class="text-end">{{ trans('messages.stock_value') }}</th>
                        <th class="text-center">{{ trans('messages.actions') }}</th>
                    </tr>
                </thead>
                <tbody>
                    @forelse($warehousesPaginator as $warehouse)
                    <tr class="{{ $warehouse->is_default ? 'table-primary' : '' }}">
                        <td>
                            <strong>{{ app()->getLocale() === 'ar' && $warehouse->name_ar ? $warehouse->name_ar : $warehouse->name }}</strong>
                            @if($warehouse->is_default)
                                <span class="badge bg-info ms-2">{{ trans('messages.default') }}</span>
                            @endif
                        </td>
                        <td>{{ $warehouse->code ?? '-' }}</td>
                        <td class="text-center">
                            @if($warehouse->is_active)
                                <span class="badge bg-success">{{ trans('messages.active') }}</span>
                            @else
                                <span class="badge bg-secondary">{{ trans('messages.inactive') }}</span>
                            @endif
                        </td>
                        <td class="text-end">{{ number_format($warehouse->total_products_count) }}</td>
                        <td class="text-end">{{ format_currency($warehouse->total_stock_value) }}</td>
                        <td class="text-center">
                            <a href="{{ route('warehouses.show', $warehouse) }}" class="btn btn-sm btn-info">
                                <i class="bi bi-eye"></i> {{ trans('messages.view') }}
                            </a>
                        </td>
                    </tr>
                    @empty
                    <tr>
                        <td colspan="6" class="text-center">{{ trans('messages.no_warehouses_found') }}</td>
                    </tr>
                    @endforelse
                </tbody>
                <tfoot>
                    <tr class="table-secondary">
                        <td colspan="3"><strong>{{ trans('messages.total') }}</strong></td>
                        <td class="text-end"><strong>{{ number_format($totalProducts) }}</strong></td>
                        <td class="text-end"><strong>{{ format_currency($totalStockValue) }}</strong></td>
                        <td></td>
                    </tr>
                </tfoot>
            </table>
        </div>
        @if(method_exists($warehousesPaginator, 'links'))
            <div class="card-footer">
                {{ $warehousesPaginator->links() }}
            </div>
        @endif
    </div>
</div>

@include('reports.partials.print-styles', ['reportTitle' => trans('messages.warehouses_report')])
@endsection

