@extends('layouts.master')

@section('title', trans('messages.stock_alerts'))

@section('content')
<div class="page-header">
    <h2>{{ trans('messages.stock_alerts') }}</h2>
    <div>
        <a href="{{ route('stock-alerts.index', ['status' => 'pending']) }}" class="btn btn-warning">
            <i class="bi bi-exclamation-triangle"></i> {{ trans('messages.pending_alerts') }}
        </a>
    </div>
</div>

<div class="card">
    <div class="card-body">
        <form method="GET" action="{{ route('stock-alerts.index') }}" class="mb-3">
            <div class="row g-3">
                <div class="col-md-4">
                    <input type="text" name="search" class="form-control" placeholder="{{ trans('messages.search') }}..." value="{{ request('search') }}">
                </div>
                <div class="col-md-3">
                    <select name="status" class="form-select">
                        <option value="">{{ trans('messages.all_statuses') }}</option>
                        <option value="pending" {{ request('status') == 'pending' ? 'selected' : '' }}>{{ trans('messages.pending') }}</option>
                        <option value="acknowledged" {{ request('status') == 'acknowledged' ? 'selected' : '' }}>{{ trans('messages.acknowledged') }}</option>
                        <option value="resolved" {{ request('status') == 'resolved' ? 'selected' : '' }}>{{ trans('messages.resolved') }}</option>
                    </select>
                </div>
                <div class="col-md-2">
                    <button type="submit" class="btn btn-secondary w-100">{{ trans('messages.filter') }}</button>
                </div>
            </div>
        </form>

        <div class="table-responsive">
            <table class="table table-hover">
                <thead>
                    <tr>
                        <th>{{ trans('messages.product') }}</th>
                        <th>{{ trans('messages.current_quantity') }}</th>
                        <th>{{ trans('messages.reorder_level') }}</th>
                        <th>{{ trans('messages.status') }}</th>
                        <th>{{ trans('messages.created_at') }}</th>
                        <th>{{ trans('messages.actions') }}</th>
                    </tr>
                </thead>
                <tbody>
                    @forelse($alerts as $alert)
                    <tr>
                        <td>
                            <strong>{{ $alert->product->name }}</strong>
                            @if($alert->product->sku)
                                <br><small class="text-muted">{{ trans('messages.sku') }}: {{ $alert->product->sku }}</small>
                            @endif
                        </td>
                        <td>
                            <span class="badge bg-{{ $alert->current_quantity <= 0 ? 'danger' : 'warning' }}">
                                {{ $alert->current_quantity }}
                            </span>
                        </td>
                        <td>{{ $alert->reorder_level }}</td>
                        <td>
                            @php
                                $badgeClass = match($alert->status) {
                                    'pending' => 'warning',
                                    'acknowledged' => 'info',
                                    'resolved' => 'success',
                                    default => 'secondary'
                                };
                            @endphp
                            <span class="badge bg-{{ $badgeClass }}">{{ trans('messages.' . $alert->status) }}</span>
                        </td>
                        <td>{{ $alert->created_at->format('Y-m-d H:i') }}</td>
                        <td>
                            @if($alert->status === 'pending')
                                <form action="{{ route('stock-alerts.acknowledge', $alert) }}" method="POST" class="d-inline">
                                    @csrf
                                    <button type="submit" class="btn btn-sm btn-info">{{ trans('messages.acknowledge') }}</button>
                                </form>
                                <form action="{{ route('stock-alerts.resolve', $alert) }}" method="POST" class="d-inline">
                                    @csrf
                                    <button type="submit" class="btn btn-sm btn-success">{{ trans('messages.resolve') }}</button>
                                </form>
                            @endif
                            <form action="{{ route('stock-alerts.destroy', $alert) }}" method="POST" class="d-inline" onsubmit="return confirm('{{ trans('messages.confirm_delete') }}')">
                                @csrf
                                @method('DELETE')
                                <button type="submit" class="btn btn-sm btn-danger">{{ trans('messages.delete') }}</button>
                            </form>
                        </td>
                    </tr>
                    @empty
                    <tr>
                        <td colspan="6" class="text-center">{{ trans('messages.no_alerts_found') }}</td>
                    </tr>
                    @endforelse
                </tbody>
            </table>
        </div>

        <div class="mt-3">
            {{ $alerts->links() }}
        </div>
    </div>
</div>
@endsection

