@extends('layouts.master')

@section('title', trans('messages.stock_take'))

@section('content')
<div class="page-header">
    <h2>{{ trans('messages.reference_number') }}: {{ $stockTake->reference_number }}</h2>
    <div>
        @if($stockTake->isDraft())
            <a href="{{ route('stock-takes.edit', $stockTake) }}" class="btn btn-warning">
                <i class="bi bi-pencil"></i> {{ trans('messages.edit') }}
            </a>
        @endif
        @if(!$stockTake->isCompleted())
            <form action="{{ route('stock-takes.complete', $stockTake) }}" method="POST" class="d-inline">
                @csrf
                <button type="submit" class="btn btn-success" onclick="return confirm('{{ trans('messages.confirm_complete_stock_take') }}')">
                    <i class="bi bi-check-circle"></i> {{ trans('messages.complete_stock_take') }}
                </button>
            </form>
        @endif
        <a href="{{ route('stock-takes.index') }}" class="btn btn-secondary">{{ trans('messages.back') }}</a>
    </div>
</div>

<div class="row">
    <div class="col-md-12">
        <div class="card mb-3">
            <div class="card-header">
                <h5 class="mb-0">{{ trans('messages.stock_take_details') }}</h5>
            </div>
            <div class="card-body">
                <div class="row mb-3">
                    <div class="col-md-4">
                        <p><strong>{{ trans('messages.stock_take_date') }}:</strong> {{ $stockTake->stock_take_date->format('Y-m-d') }}</p>
                        <p><strong>{{ trans('messages.type') }}:</strong> 
                            <span class="badge bg-info">{{ trans('messages.' . $stockTake->type) }}</span>
                        </p>
                    </div>
                    <div class="col-md-4">
                        <p><strong>{{ trans('messages.status') }}:</strong> 
                            @php
                                $badgeClass = match($stockTake->status) {
                                    'draft' => 'secondary',
                                    'in_progress' => 'warning',
                                    'completed' => 'success',
                                    default => 'secondary'
                                };
                            @endphp
                            <span class="badge bg-{{ $badgeClass }}">{{ trans('messages.' . $stockTake->status) }}</span>
                        </p>
                        <p><strong>{{ trans('messages.items_count') }}:</strong> {{ $stockTake->items->count() }}</p>
                    </div>
                    <div class="col-md-4">
                        <p><strong>{{ trans('messages.created_by') }}:</strong> {{ $stockTake->creator->name ?? '-' }}</p>
                        @if($stockTake->completer)
                            <p><strong>{{ trans('messages.completed_by') }}:</strong> {{ $stockTake->completer->name }}</p>
                            <p><strong>{{ trans('messages.completed_at') }}:</strong> {{ $stockTake->completed_at->format('Y-m-d H:i') }}</p>
                        @endif
                    </div>
                </div>

                @if($stockTake->notes)
                <div class="mb-3">
                    <strong>{{ trans('messages.notes') }}:</strong>
                    <p>{{ $stockTake->notes }}</p>
                </div>
                @endif

                <h5 class="mt-4">{{ trans('messages.items') }}</h5>
                <div class="table-responsive">
                    <table class="table table-striped">
                        <thead>
                            <tr>
                                <th>{{ trans('messages.product') }}</th>
                                <th>{{ trans('messages.system_quantity') }}</th>
                                <th>{{ trans('messages.counted_quantity') }}</th>
                                <th>{{ trans('messages.variance') }}</th>
                                <th>{{ trans('messages.variance_value') }}</th>
                            </tr>
                        </thead>
                        <tbody>
                            @foreach($stockTake->items as $item)
                            <tr>
                                <td>{{ $item->product->name }}</td>
                                <td>{{ $item->system_quantity }}</td>
                                <td>{{ $item->counted_quantity }}</td>
                                <td>
                                    <span class="badge bg-{{ $item->variance == 0 ? 'success' : ($item->variance > 0 ? 'info' : 'danger') }}">
                                        {{ $item->variance > 0 ? '+' : '' }}{{ $item->variance }}
                                    </span>
                                </td>
                                <td>{{ $item->variance_value ? format_currency($item->variance_value) : '-' }}</td>
                            </tr>
                            @endforeach
                        </tbody>
                    </table>
                </div>
            </div>
        </div>
    </div>
</div>
@endsection

