@extends('layouts.master')

@section('title', trans('messages.edit') . ' - ' . trans('messages.treasury'))

@section('content')
<div class="page-header">
    <h2>{{ trans('messages.edit') }} - {{ trans('messages.treasury') }}</h2>
</div>

<div class="card">
    <div class="card-body">
        <form method="POST" action="{{ route('treasury.update', $treasury) }}">
            @csrf
            @method('PUT')
            <div class="row">
                <div class="col-md-6">
                    <div class="mb-3">
                        <label for="date" class="form-label">{{ trans('messages.date') }} *</label>
                        <input type="date" class="form-control @error('date') is-invalid @enderror" id="date" name="date" value="{{ old('date', $treasury->date ? \Carbon\Carbon::parse($treasury->date)->format('Y-m-d') : '') }}" required>
                        @error('date')
                            <div class="invalid-feedback">{{ $message }}</div>
                        @enderror
                    </div>
                </div>
                <div class="col-md-6">
                    <div class="mb-3">
                        <label for="type" class="form-label">{{ trans('messages.type') }} *</label>
                        <select class="form-select @error('type') is-invalid @enderror" id="type" name="type" required>
                            <option value="">{{ trans('messages.select') }}</option>
                            <option value="income" {{ old('type', $treasury->type) === 'income' ? 'selected' : '' }}>{{ trans('messages.income') }}</option>
                            <option value="expense" {{ old('type', $treasury->type) === 'expense' ? 'selected' : '' }}>{{ trans('messages.expense') }}</option>
                        </select>
                        @error('type')
                            <div class="invalid-feedback">{{ $message }}</div>
                        @enderror
                    </div>
                </div>
            </div>
            <div class="row">
                <div class="col-md-6">
                    <div class="mb-3">
                        <label for="amount" class="form-label">{{ trans('messages.amount') }} *</label>
                        <input type="number" step="0.01" min="0.01" class="form-control @error('amount') is-invalid @enderror" id="amount" name="amount" value="{{ old('amount', $treasury->amount) }}" required>
                        @error('amount')
                            <div class="invalid-feedback">{{ $message }}</div>
                        @enderror
                    </div>
                </div>
                <div class="col-md-6">
                    <div class="mb-3">
                        <label for="payment_method" class="form-label">{{ trans('messages.payment_method') }} *</label>
                        <select class="form-select @error('payment_method') is-invalid @enderror" id="payment_method" name="payment_method" required>
                            <option value="">{{ trans('messages.select') }}</option>
                            <option value="cash" {{ old('payment_method', $treasury->payment_method) === 'cash' ? 'selected' : '' }}>{{ trans('messages.cash') }}</option>
                            <option value="card" {{ old('payment_method', $treasury->payment_method) === 'card' ? 'selected' : '' }}>{{ trans('messages.card') }}</option>
                            <option value="bank" {{ old('payment_method', $treasury->payment_method) === 'bank' ? 'selected' : '' }}>{{ trans('messages.bank') }}</option>
                            <option value="other" {{ old('payment_method', $treasury->payment_method) === 'other' ? 'selected' : '' }}>{{ trans('messages.other') }}</option>
                        </select>
                        @error('payment_method')
                            <div class="invalid-feedback">{{ $message }}</div>
                        @enderror
                    </div>
                </div>
            </div>
            <div class="mb-3">
                <label for="description" class="form-label">{{ trans('messages.description') }}</label>
                <textarea class="form-control @error('description') is-invalid @enderror" id="description" name="description" rows="3">{{ old('description', $treasury->description) }}</textarea>
                @error('description')
                    <div class="invalid-feedback">{{ $message }}</div>
                @enderror
                <div id="expense-buttons" class="mt-2" style="display: none;">
                    <small class="text-muted d-block mb-2">{{ trans('messages.quick_add_description') }}:</small>
                    <div class="d-flex flex-wrap gap-2">
                        <button type="button" class="btn btn-sm btn-outline-danger quick-description-btn" data-text="{{ trans('messages.expenses_utilities') }}">{{ trans('messages.expenses_utilities') }}</button>
                        <button type="button" class="btn btn-sm btn-outline-danger quick-description-btn" data-text="{{ trans('messages.transportation') }}">{{ trans('messages.transportation') }}</button>
                        <button type="button" class="btn btn-sm btn-outline-danger quick-description-btn" data-text="{{ trans('messages.product_loss') }}">{{ trans('messages.product_loss') }}</button>
                        <button type="button" class="btn btn-sm btn-outline-danger quick-description-btn" data-text="{{ trans('messages.external_service') }}">{{ trans('messages.external_service') }}</button>
                        <button type="button" class="btn btn-sm btn-outline-danger quick-description-btn" data-text="{{ trans('messages.store_setup') }}">{{ trans('messages.store_setup') }}</button>
                    </div>
                </div>
                <div id="income-buttons" class="mt-2" style="display: none;">
                    <small class="text-muted d-block mb-2">{{ trans('messages.quick_add_description') }}:</small>
                    <div class="d-flex flex-wrap gap-2">
                        <button type="button" class="btn btn-sm btn-outline-success quick-description-btn" data-text="{{ trans('messages.debt_recovery') }}">{{ trans('messages.debt_recovery') }}</button>
                        <button type="button" class="btn btn-sm btn-outline-success quick-description-btn" data-text="{{ trans('messages.special_service') }}">{{ trans('messages.special_service') }}</button>
                        <button type="button" class="btn btn-sm btn-outline-success quick-description-btn" data-text="{{ trans('messages.commission') }}">{{ trans('messages.commission') }}</button>
                        <button type="button" class="btn btn-sm btn-outline-success quick-description-btn" data-text="{{ trans('messages.coupons') }}">{{ trans('messages.coupons') }}</button>
                        <button type="button" class="btn btn-sm btn-outline-success quick-description-btn" data-text="{{ trans('messages.supplier_gift') }}">{{ trans('messages.supplier_gift') }}</button>
                    </div>
                </div>
            </div>
            <div class="d-flex justify-content-between">
                <a href="{{ route('treasury.index') }}" class="btn btn-secondary">{{ trans('messages.cancel') }}</a>
                <button type="submit" class="btn btn-primary">{{ trans('messages.update') }}</button>
            </div>
        </form>
    </div>
</div>

<script>
document.addEventListener('DOMContentLoaded', function() {
    const typeSelect = document.getElementById('type');
    const expenseButtons = document.getElementById('expense-buttons');
    const incomeButtons = document.getElementById('income-buttons');
    const descriptionTextarea = document.getElementById('description');
    const quickDescriptionBtns = document.querySelectorAll('.quick-description-btn');

    // Show/hide buttons based on type selection
    function toggleButtons() {
        if (typeSelect.value === 'expense') {
            expenseButtons.style.display = 'block';
            incomeButtons.style.display = 'none';
        } else if (typeSelect.value === 'income') {
            expenseButtons.style.display = 'none';
            incomeButtons.style.display = 'block';
        } else {
            expenseButtons.style.display = 'none';
            incomeButtons.style.display = 'none';
        }
    }

    // Initial check
    toggleButtons();

    // Listen for type changes
    typeSelect.addEventListener('change', toggleButtons);

    // Handle quick description button clicks
    quickDescriptionBtns.forEach(function(btn) {
        btn.addEventListener('click', function() {
            const text = this.getAttribute('data-text');
            const currentValue = descriptionTextarea.value.trim();
            
            if (currentValue === '') {
                descriptionTextarea.value = text;
            } else {
                // Add comma and space if there's existing text
                descriptionTextarea.value = currentValue + ', ' + text;
            }
            
            // Focus back to textarea
            descriptionTextarea.focus();
        });
    });
});
</script>
@endsection

