@extends('layouts.master')

@section('title', trans('messages.all_movements'))

@section('content')
<div class="page-header">
    <h2>{{ trans('messages.all_movements') }}</h2>
    <div>
        <a href="{{ route('treasury.dashboard') }}" class="btn btn-info"><i class="bi bi-speedometer2"></i> {{ trans('messages.treasury_dashboard') }}</a>
        @if(auth()->user()->hasAnyRole(['Super Admin', 'Admin']))
            <a href="{{ route('treasury.create') }}" class="btn btn-success"><i class="bi bi-plus-circle"></i> {{ trans('messages.add_transaction') }}</a>
        @endif
        @if(auth()->user()->hasAnyRole(['Super Admin', 'Admin', 'User']))
            <a href="{{ route('treasury.export', request()->query()) }}" class="btn btn-primary"><i class="bi bi-download"></i> {{ trans('messages.export_excel') }}</a>
            <a href="{{ route('treasury.export_pdf', request()->query()) }}" class="btn btn-warning" target="_blank"><i class="bi bi-file-pdf"></i> {{ trans('messages.export_pdf') }}</a>
        @endif
    </div>
</div>

<!-- Filters -->
<div class="card mb-3">
    <div class="card-body">
        <form method="GET" action="{{ route('treasury.index') }}" class="row g-3">
            <div class="col-md-2">
                <label for="start_date" class="form-label">{{ trans('messages.start_date') }}</label>
                <input type="date" class="form-control" id="start_date" name="start_date" value="{{ $startDate }}">
            </div>
            <div class="col-md-2">
                <label for="end_date" class="form-label">{{ trans('messages.end_date') }}</label>
                <input type="date" class="form-control" id="end_date" name="end_date" value="{{ $endDate }}">
            </div>
            <div class="col-md-2">
                <label for="type" class="form-label">{{ trans('messages.type') }}</label>
                <select class="form-select" id="type" name="type">
                    <option value="">{{ trans('messages.all') }}</option>
                    <option value="income" {{ $type === 'income' ? 'selected' : '' }}>{{ trans('messages.income') }}</option>
                    <option value="expense" {{ $type === 'expense' ? 'selected' : '' }}>{{ trans('messages.expense') }}</option>
                </select>
            </div>
            <div class="col-md-2">
                <label for="payment_method" class="form-label">{{ trans('messages.payment_method') }}</label>
                <select class="form-select" id="payment_method" name="payment_method">
                    <option value="">{{ trans('messages.all') }}</option>
                    <option value="cash" {{ $paymentMethod === 'cash' ? 'selected' : '' }}>{{ trans('messages.cash') }}</option>
                    <option value="card" {{ $paymentMethod === 'card' ? 'selected' : '' }}>{{ trans('messages.card') }}</option>
                    <option value="bank" {{ $paymentMethod === 'bank' ? 'selected' : '' }}>{{ trans('messages.bank') }}</option>
                    <option value="other" {{ $paymentMethod === 'other' ? 'selected' : '' }}>{{ trans('messages.other') }}</option>
                </select>
            </div>
            <div class="col-md-2">
                <label for="reference_type" class="form-label">{{ trans('messages.reference_type') }}</label>
                <select class="form-select" id="reference_type" name="reference_type">
                    <option value="">{{ trans('messages.all') }}</option>
                    <option value="sale_invoice" {{ $referenceType === 'sale_invoice' ? 'selected' : '' }}>{{ trans('messages.sale_invoice') }}</option>
                    <option value="purchase_invoice" {{ $referenceType === 'purchase_invoice' ? 'selected' : '' }}>{{ trans('messages.purchase_invoice') }}</option>
                    <option value="manual" {{ $referenceType === 'manual' ? 'selected' : '' }}>{{ trans('messages.manual') }}</option>
                    <option value="supplier_payment" {{ $referenceType === 'supplier_payment' ? 'selected' : '' }}>{{ trans('messages.supplier_payment') }}</option>
                    <option value="customer_payment" {{ $referenceType === 'customer_payment' ? 'selected' : '' }}>{{ trans('messages.customer_payment') }}</option>
                    <option value="refund" {{ $referenceType === 'refund' ? 'selected' : '' }}>{{ trans('messages.refund') }}</option>
                </select>
            </div>
            <div class="col-md-2 d-flex align-items-end">
                <button type="submit" class="btn btn-secondary w-100">{{ trans('messages.filter') }}</button>
            </div>
        </form>
    </div>
</div>

@if(auth()->user()->hasAnyRole(['Super Admin', 'Admin']))
<div class="mb-3">
    <button type="button" id="delete-selected-btn" class="btn btn-danger" disabled>
        <i class="bi bi-trash"></i> {{ trans('messages.delete_selected') }}
    </button>
</div>
@endif

<div class="card">
    <div class="card-body">
        <div class="table-responsive">
            <table class="table table-hover">
                    <thead>
                        <tr>
                            @if(auth()->user()->hasAnyRole(['Super Admin', 'Admin']))
                            <th style="width: 40px;">
                                <input type="checkbox" id="select-all" title="{{ trans('messages.select_all') }}">
                            </th>
                            @endif
                            <th>
                                <a href="{{ request()->fullUrlWithQuery(['sort' => 'date', 'direction' => ($sort === 'date' && $direction === 'asc') ? 'desc' : 'asc']) }}" class="text-decoration-none text-dark">
                                    {{ trans('messages.date') }}
                                    @if($sort === 'date')
                                        <i class="bi bi-arrow-{{ $direction === 'asc' ? 'up' : 'down' }}"></i>
                                    @else
                                        <i class="bi bi-arrow-down-up text-muted"></i>
                                    @endif
                                </a>
                            </th>
                            <th>
                                <a href="{{ request()->fullUrlWithQuery(['sort' => 'type', 'direction' => ($sort === 'type' && $direction === 'asc') ? 'desc' : 'asc']) }}" class="text-decoration-none text-dark">
                                    {{ trans('messages.type') }}
                                    @if($sort === 'type')
                                        <i class="bi bi-arrow-{{ $direction === 'asc' ? 'up' : 'down' }}"></i>
                                    @else
                                        <i class="bi bi-arrow-down-up text-muted"></i>
                                    @endif
                                </a>
                            </th>
                            <th>
                                <a href="{{ request()->fullUrlWithQuery(['sort' => 'reference_type', 'direction' => ($sort === 'reference_type' && $direction === 'asc') ? 'desc' : 'asc']) }}" class="text-decoration-none text-dark">
                                    {{ trans('messages.reference_type') }}
                                    @if($sort === 'reference_type')
                                        <i class="bi bi-arrow-{{ $direction === 'asc' ? 'up' : 'down' }}"></i>
                                    @else
                                        <i class="bi bi-arrow-down-up text-muted"></i>
                                    @endif
                                </a>
                            </th>
                            <th>
                                <a href="{{ request()->fullUrlWithQuery(['sort' => 'amount', 'direction' => ($sort === 'amount' && $direction === 'asc') ? 'desc' : 'asc']) }}" class="text-decoration-none text-dark">
                                    {{ trans('messages.amount') }}
                                    @if($sort === 'amount')
                                        <i class="bi bi-arrow-{{ $direction === 'asc' ? 'up' : 'down' }}"></i>
                                    @else
                                        <i class="bi bi-arrow-down-up text-muted"></i>
                                    @endif
                                </a>
                            </th>
                            <th>
                                <a href="{{ request()->fullUrlWithQuery(['sort' => 'payment_method', 'direction' => ($sort === 'payment_method' && $direction === 'asc') ? 'desc' : 'asc']) }}" class="text-decoration-none text-dark">
                                    {{ trans('messages.payment_method') }}
                                    @if($sort === 'payment_method')
                                        <i class="bi bi-arrow-{{ $direction === 'asc' ? 'up' : 'down' }}"></i>
                                    @else
                                        <i class="bi bi-arrow-down-up text-muted"></i>
                                    @endif
                                </a>
                            </th>
                            <th>{{ trans('messages.description') }}</th>
                            <th>{{ trans('messages.created_by') }}</th>
                            @if(auth()->user()->hasAnyRole(['Super Admin', 'Admin']))
                            <th>{{ trans('messages.actions') }}</th>
                            @endif
                        </tr>
                    </thead>
                    <tbody>
                        @forelse($treasuries as $treasury)
                        <tr>
                            @if(auth()->user()->hasAnyRole(['Super Admin', 'Admin']))
                            <td>
                                <input type="checkbox" class="item-checkbox" value="{{ $treasury->id }}">
                            </td>
                            @endif
                            <td>{{ $treasury->date ? \Carbon\Carbon::parse($treasury->date)->format('Y-m-d') : '-' }}</td>
                            <td>
                                <span class="badge {{ $treasury->type === 'income' ? 'bg-success' : 'bg-danger' }}">
                                    {{ trans('messages.' . $treasury->type) }}
                                </span>
                            </td>
                            <td>{{ trans('messages.' . $treasury->reference_type) }}</td>
                            <td>{{ format_currency($treasury->amount) }}</td>
                            <td>{{ trans('messages.' . $treasury->payment_method) }}</td>
                            <td>{{ $treasury->description ?? '-' }}</td>
                            <td>{{ $treasury->creator->name ?? '-' }}</td>
                            @if(auth()->user()->hasAnyRole(['Super Admin', 'Admin']))
                            <td>
                                <a href="{{ route('treasury.show', $treasury) }}" class="btn btn-sm btn-info" title="{{ trans('messages.view') }}"><i class="bi bi-eye"></i></a>
                                <a href="{{ route('treasury.edit', $treasury) }}" class="btn btn-sm btn-warning" title="{{ trans('messages.edit') }}"><i class="bi bi-pencil"></i></a>
                                <form action="{{ route('treasury.destroy', $treasury) }}" method="POST" class="d-inline delete-form">
                                    @csrf
                                    @method('DELETE')
                                    <button type="submit" class="btn btn-sm btn-danger" title="{{ trans('messages.delete') }}" onclick="event.preventDefault(); confirmAction('{{ trans('messages.confirm_delete') }}', '{{ trans('messages.confirm_delete') }}', () => this.closest('form').submit()); return false;"><i class="bi bi-trash"></i></button>
                                </form>
                            </td>
                            @endif
                        </tr>
                        @empty
                        <tr>
                            <td colspan="{{ auth()->user()->hasAnyRole(['Super Admin', 'Admin']) ? '9' : '7' }}" class="text-center">{{ trans('messages.no_data') }}</td>
                        </tr>
                        @endforelse
                    </tbody>
                </table>
            </div>
        </div>
    </div>
</div>

<!-- Hidden form for bulk delete -->
<form id="bulk-delete-form" method="POST" action="{{ route('treasury.bulk_delete') }}" style="display: none;">
    @csrf
</form>

{{ $treasuries->links() }}

@include('partials.bulk-delete-modal')
@endsection

