@php
    $locale = app()->getLocale();
    $isRTL = $locale === 'ar';
    $dir = $isRTL ? 'rtl' : 'ltr';
@endphp
<!DOCTYPE html>
<html lang="{{ $locale }}" dir="{{ $dir }}">
<head>
    <meta charset="UTF-8">
    <title>{{ trans('messages.treasury') }}</title>
    <style>
        @charset "UTF-8";
        
        body { 
            font-family: {{ $isRTL ? "'Cairo', DejaVu Sans, sans-serif" : "DejaVu Sans, 'Cabin', sans-serif" }};
            direction: {{ $dir }};
            font-size: 12px;
            unicode-bidi: embed;
        }
        
        @if($isRTL)
        * {
            font-family: 'Cairo', DejaVu Sans, sans-serif !important;
        }
        @else
        * {
            font-family: DejaVu Sans, 'Cabin', sans-serif !important;
        }
        @endif
        
        table { width: 100%; border-collapse: collapse; margin-top: 20px; }
        th, td { border: 1px solid #ddd; padding: 8px; text-align: {{ $isRTL ? 'right' : 'left' }}; }
        th { background-color: #f2f2f2; }
        .summary { margin-bottom: 20px; }
        .summary-card { display: inline-block; width: 30%; margin: 10px; padding: 15px; border: 1px solid #ddd; }
    </style>
</head>
<body>
    <h2>{{ trans('messages.treasury') }}</h2>
    
    @if($startDate && $endDate)
    <p><strong>{{ trans('messages.date_range') }}:</strong> {{ $startDate }} - {{ $endDate }}</p>
    @endif
    
    <div class="summary">
        <div class="summary-card">
            <strong>{{ trans('messages.total_cash_in') }}:</strong> {{ format_currency($totalIncome) }}
        </div>
        <div class="summary-card">
            <strong>{{ trans('messages.total_cash_out') }}:</strong> {{ format_currency($totalExpense) }}
        </div>
        <div class="summary-card">
            <strong>{{ trans('messages.current_cash_balance') }}:</strong> {{ format_currency($balance) }}
        </div>
    </div>

    <table>
        <thead>
            <tr>
                <th>{{ trans('messages.date') }}</th>
                <th>{{ trans('messages.type') }}</th>
                <th>{{ trans('messages.reference_type') }}</th>
                <th>{{ trans('messages.amount') }}</th>
                <th>{{ trans('messages.payment_method') }}</th>
                <th>{{ trans('messages.description') }}</th>
                <th>{{ trans('messages.created_by') }}</th>
            </tr>
        </thead>
        <tbody>
            @foreach($treasuries as $treasury)
            <tr>
                <td>{{ $treasury->date ? \Carbon\Carbon::parse($treasury->date)->format('Y-m-d') : '-' }}</td>
                <td>{{ trans('messages.' . $treasury->type) }}</td>
                <td>{{ trans('messages.' . $treasury->reference_type) }}</td>
                <td>{{ format_currency($treasury->amount) }}</td>
                <td>{{ trans('messages.' . $treasury->payment_method) }}</td>
                <td>{{ $treasury->description ?? '-' }}</td>
                <td>{{ $treasury->creator->name ?? '-' }}</td>
            </tr>
            @endforeach
        </tbody>
    </table>
</body>
</html>

