<!DOCTYPE html>
<html lang="{{ app()->getLocale() }}" dir="{{ app()->getLocale() === 'ar' ? 'rtl' : 'ltr' }}">
<head>
    <meta charset="UTF-8">
    <meta name="viewport" content="width=device-width, initial-scale=1.0">
    <title>{{ trans('messages.treasury') }}</title>
    <link href="{{ asset('lib/css/bootstrap.min.css') }}" rel="stylesheet">
    <link rel="stylesheet" href="{{ asset('lib/fonts/google-fonts.css') }}">
    <style>
        @media print {
            .no-print { display: none; }
        }
        @php
            $isRTL = app()->getLocale() === 'ar';
        @endphp
        body { 
            font-family: {{ $isRTL ? "'Cairo', 'DejaVu Sans', sans-serif" : "'Cabin', 'DejaVu Sans', sans-serif" }};
            direction: {{ $isRTL ? 'rtl' : 'ltr' }};
        }
        * {
            font-family: {{ $isRTL ? "'Cairo', 'DejaVu Sans', sans-serif" : "'Cabin', 'DejaVu Sans', sans-serif" }} !important;
        }
        [dir="rtl"] { direction: rtl; text-align: right; }
        [dir="ltr"] { direction: ltr; text-align: left; }
    </style>
</head>
<body>
    <div class="container mt-4">
        <div class="d-flex justify-content-between mb-4 no-print">
            <h2>{{ trans('messages.treasury') }}</h2>
            <div>
                <button onclick="window.print()" class="btn btn-primary">{{ trans('messages.print') }}</button>
                <button onclick="window.close()" class="btn btn-secondary ms-2">{{ trans('messages.close') }}</button>
            </div>
        </div>
        
        <div class="card">
            <div class="card-body">
                @if($startDate && $endDate)
                <p><strong>{{ trans('messages.date_range') }}:</strong> {{ $startDate }} - {{ $endDate }}</p>
                @endif
                
                <div class="row mb-4">
                    <div class="col-md-4">
                        <div class="card bg-success text-white">
                            <div class="card-body">
                                <h5>{{ trans('messages.total_cash_in') }}</h5>
                                <h3>{{ format_currency($totalIncome) }}</h3>
                            </div>
                        </div>
                    </div>
                    <div class="col-md-4">
                        <div class="card bg-danger text-white">
                            <div class="card-body">
                                <h5>{{ trans('messages.total_cash_out') }}</h5>
                                <h3>{{ format_currency($totalExpense) }}</h3>
                            </div>
                        </div>
                    </div>
                    <div class="col-md-4">
                        <div class="card {{ $balance >= 0 ? 'bg-primary' : 'bg-warning' }} text-white">
                            <div class="card-body">
                                <h5>{{ trans('messages.current_cash_balance') }}</h5>
                                <h3>{{ format_currency($balance) }}</h3>
                            </div>
                        </div>
                    </div>
                </div>

                <table class="table table-bordered">
                    <thead>
                        <tr>
                            <th>{{ trans('messages.date') }}</th>
                            <th>{{ trans('messages.type') }}</th>
                            <th>{{ trans('messages.reference_type') }}</th>
                            <th>{{ trans('messages.amount') }}</th>
                            <th>{{ trans('messages.payment_method') }}</th>
                            <th>{{ trans('messages.description') }}</th>
                            <th>{{ trans('messages.created_by') }}</th>
                        </tr>
                    </thead>
                    <tbody>
                        @foreach($treasuries as $treasury)
                        <tr>
                            <td>{{ $treasury->date ? \Carbon\Carbon::parse($treasury->date)->format('Y-m-d') : '-' }}</td>
                            <td>{{ trans('messages.' . $treasury->type) }}</td>
                            <td>{{ trans('messages.' . $treasury->reference_type) }}</td>
                            <td>{{ format_currency($treasury->amount) }}</td>
                            <td>{{ trans('messages.' . $treasury->payment_method) }}</td>
                            <td>{{ $treasury->description ?? '-' }}</td>
                            <td>{{ $treasury->creator->name ?? '-' }}</td>
                        </tr>
                        @endforeach
                    </tbody>
                </table>
            </div>
        </div>
    </div>
</body>
</html>

