@extends('layouts.master')

@section('title', trans('messages.warehouses'))

@section('content')
@php
    $sort = request()->get('sort', 'created_at');
    $direction = request()->get('direction', 'desc');
@endphp
<div class="page-header">
    <h2>{{ trans('messages.warehouses') }}</h2>
    <div>
        <a href="{{ route('warehouses.create') }}" class="btn btn-primary"><i class="bi bi-plus-circle"></i> {{ trans('messages.create_warehouse') }}</a>
        <a href="{{ route('warehouses.transfer.index') }}" class="btn btn-info"><i class="bi bi-arrow-left-right"></i> {{ trans('messages.transfer_between_warehouses') }}</a>
    </div>
</div>

<div class="card">
    <div class="card-body">
        <form method="GET" action="{{ route('warehouses.index') }}" class="mb-3">
            <div class="row g-3">
                <div class="col-md-8">
                    <input type="text" name="search" class="form-control" placeholder="{{ trans('messages.search') }}..." value="{{ request('search') }}">
                </div>
                <div class="col-md-2">
                    <select name="is_active" class="form-select">
                        <option value="">{{ trans('messages.all') }}</option>
                        <option value="1" {{ request('is_active') === '1' ? 'selected' : '' }}>{{ trans('messages.active') }}</option>
                        <option value="0" {{ request('is_active') === '0' ? 'selected' : '' }}>{{ trans('messages.inactive') }}</option>
                    </select>
                </div>
                <div class="col-md-2">
                    <button type="submit" class="btn btn-secondary w-100">{{ trans('messages.search') }}</button>
                </div>
            </div>
        </form>

        <div class="table-responsive">
            <table class="table table-hover">
                <thead>
                    <tr>
                        <th>
                            <a href="{{ request()->fullUrlWithQuery(['sort' => 'name', 'direction' => ($sort === 'name' && $direction === 'asc') ? 'desc' : 'asc']) }}" class="text-decoration-none text-dark">
                                {{ trans('messages.warehouse_name') }}
                                @if($sort === 'name')
                                    <i class="bi bi-arrow-{{ $direction === 'asc' ? 'up' : 'down' }}"></i>
                                @else
                                    <i class="bi bi-arrow-down-up text-muted"></i>
                                @endif
                            </a>
                        </th>
                        <th>
                            <a href="{{ request()->fullUrlWithQuery(['sort' => 'code', 'direction' => ($sort === 'code' && $direction === 'asc') ? 'desc' : 'asc']) }}" class="text-decoration-none text-dark">
                                {{ trans('messages.warehouse_code') }}
                                @if($sort === 'code')
                                    <i class="bi bi-arrow-{{ $direction === 'asc' ? 'up' : 'down' }}"></i>
                                @else
                                    <i class="bi bi-arrow-down-up text-muted"></i>
                                @endif
                            </a>
                        </th>
                        <th>{{ trans('messages.warehouse_address') }}</th>
                        <th>{{ trans('messages.warehouse_phone') }}</th>
                        <th>
                            <a href="{{ request()->fullUrlWithQuery(['sort' => 'is_default', 'direction' => ($sort === 'is_default' && $direction === 'asc') ? 'desc' : 'asc']) }}" class="text-decoration-none text-dark">
                                {{ trans('messages.is_default_warehouse') }}
                                @if($sort === 'is_default')
                                    <i class="bi bi-arrow-{{ $direction === 'asc' ? 'up' : 'down' }}"></i>
                                @else
                                    <i class="bi bi-arrow-down-up text-muted"></i>
                                @endif
                            </a>
                        </th>
                        <th>
                            <a href="{{ request()->fullUrlWithQuery(['sort' => 'is_active', 'direction' => ($sort === 'is_active' && $direction === 'asc') ? 'desc' : 'asc']) }}" class="text-decoration-none text-dark">
                                {{ trans('messages.is_active_warehouse') }}
                                @if($sort === 'is_active')
                                    <i class="bi bi-arrow-{{ $direction === 'asc' ? 'up' : 'down' }}"></i>
                                @else
                                    <i class="bi bi-arrow-down-up text-muted"></i>
                                @endif
                            </a>
                        </th>
                        <th>{{ trans('messages.total_products_count') }}</th>
                        <th>{{ trans('messages.actions') }}</th>
                    </tr>
                </thead>
                <tbody>
                    @forelse($warehouses as $warehouse)
                    <tr>
                        <td><a href="{{ route('warehouses.show', $warehouse) }}">{{ $warehouse->name }}</a></td>
                        <td>{{ $warehouse->code ?? 'N/A' }}</td>
                        <td>{{ $warehouse->address ?? 'N/A' }}</td>
                        <td>{{ $warehouse->phone ?? 'N/A' }}</td>
                        <td>
                            @if($warehouse->is_default)
                                <span class="badge bg-primary">{{ trans('messages.yes') }}</span>
                            @else
                                <span class="badge bg-secondary">{{ trans('messages.no') }}</span>
                            @endif
                        </td>
                        <td>
                            @if($warehouse->is_active)
                                <span class="badge bg-success">{{ trans('messages.active') }}</span>
                            @else
                                <span class="badge bg-danger">{{ trans('messages.inactive') }}</span>
                            @endif
                        </td>
                        <td>{{ $warehouse->products_count }}</td>
                        <td>
                            <a href="{{ route('warehouses.show', $warehouse) }}" class="btn btn-sm btn-info" title="{{ trans('messages.view') }}"><i class="bi bi-eye"></i></a>
                            <a href="{{ route('warehouses.edit', $warehouse) }}" class="btn btn-sm btn-warning" title="{{ trans('messages.edit') }}"><i class="bi bi-pencil"></i></a>
                            <form action="{{ route('warehouses.destroy', $warehouse) }}" method="POST" class="d-inline delete-form">
                                @csrf
                                @method('DELETE')
                                <button type="submit" class="btn btn-sm btn-danger" title="{{ trans('messages.delete') }}" onclick="event.preventDefault(); confirmAction('{{ trans('messages.confirm_delete') }}', '{{ trans('messages.confirm_delete') }}', () => this.closest('form').submit()); return false;"><i class="bi bi-trash"></i></button>
                            </form>
                        </td>
                    </tr>
                    @empty
                    <tr>
                        <td colspan="8" class="text-center">{{ trans('messages.no_warehouses_found') }}</td>
                    </tr>
                    @endforelse
                </tbody>
            </table>
        </div>

        {{ $warehouses->links() }}
    </div>
</div>
@endsection

