@extends('layouts.master')

@section('title', trans('messages.transfer_between_warehouses'))

@section('content')
<div class="page-header">
    <h2>{{ trans('messages.transfer_between_warehouses') }}</h2>
    <a href="{{ route('warehouses.index') }}" class="btn btn-secondary">{{ trans('messages.back') }}</a>
</div>

<div class="card">
    <div class="card-body">
        <form method="POST" action="{{ route('warehouses.transfer.store') }}">
            @csrf
            <div class="row">
                <div class="col-md-6">
                    <div class="mb-3">
                        <label for="product_id" class="form-label">{{ trans('messages.product') }} *</label>
                        <select class="form-select @error('product_id') is-invalid @enderror" id="product_id" name="product_id" required>
                            <option value="">{{ trans('messages.select_product') }}</option>
                            @foreach($products as $product)
                                <option value="{{ $product->id }}" {{ old('product_id') == $product->id ? 'selected' : '' }}>
                                    {{ $product->name }} ({{ $product->sku }})
                                </option>
                            @endforeach
                        </select>
                        @error('product_id')
                            <div class="invalid-feedback">{{ $message }}</div>
                        @enderror
                    </div>
                </div>
                <div class="col-md-6">
                    <div class="mb-3">
                        <label for="quantity" class="form-label">{{ trans('messages.transfer_quantity') }} *</label>
                        <input type="number" class="form-control @error('quantity') is-invalid @enderror" id="quantity" name="quantity" value="{{ old('quantity') }}" min="1" required>
                        @error('quantity')
                            <div class="invalid-feedback">{{ $message }}</div>
                        @enderror
                    </div>
                </div>
            </div>
            <div class="row">
                <div class="col-md-6">
                    <div class="mb-3">
                        <label for="from_warehouse_id" class="form-label">{{ trans('messages.transfer_from_warehouse') }} *</label>
                        <select class="form-select @error('from_warehouse_id') is-invalid @enderror" id="from_warehouse_id" name="from_warehouse_id" required>
                            <option value="">{{ trans('messages.select_warehouse') }}</option>
                            @foreach($warehouses as $warehouse)
                                <option value="{{ $warehouse->id }}" {{ old('from_warehouse_id') == $warehouse->id ? 'selected' : '' }}>
                                    {{ $warehouse->name }}
                                </option>
                            @endforeach
                        </select>
                        @error('from_warehouse_id')
                            <div class="invalid-feedback">{{ $message }}</div>
                        @enderror
                    </div>
                </div>
                <div class="col-md-6">
                    <div class="mb-3">
                        <label for="to_warehouse_id" class="form-label">{{ trans('messages.transfer_to_warehouse') }} *</label>
                        <select class="form-select @error('to_warehouse_id') is-invalid @enderror" id="to_warehouse_id" name="to_warehouse_id" required>
                            <option value="">{{ trans('messages.select_warehouse') }}</option>
                            @foreach($warehouses as $warehouse)
                                <option value="{{ $warehouse->id }}" {{ old('to_warehouse_id') == $warehouse->id ? 'selected' : '' }}>
                                    {{ $warehouse->name }}
                                </option>
                            @endforeach
                        </select>
                        @error('to_warehouse_id')
                            <div class="invalid-feedback">{{ $message }}</div>
                        @enderror
                    </div>
                </div>
            </div>
            <div class="mb-3">
                <label for="notes" class="form-label">{{ trans('messages.transfer_notes') }}</label>
                <textarea class="form-control @error('notes') is-invalid @enderror" id="notes" name="notes" rows="3">{{ old('notes') }}</textarea>
                @error('notes')
                    <div class="invalid-feedback">{{ $message }}</div>
                @enderror
            </div>
            <button type="submit" class="btn btn-primary">{{ trans('messages.transfer') }}</button>
        </form>
    </div>
</div>

@push('scripts')
<script>
document.addEventListener('DOMContentLoaded', function() {
    const fromWarehouse = document.getElementById('from_warehouse_id');
    const toWarehouse = document.getElementById('to_warehouse_id');
    
    // Prevent selecting the same warehouse
    fromWarehouse.addEventListener('change', function() {
        const fromValue = this.value;
        Array.from(toWarehouse.options).forEach(option => {
            if (option.value === fromValue && option.value !== '') {
                option.disabled = true;
            } else {
                option.disabled = false;
            }
        });
    });
    
    toWarehouse.addEventListener('change', function() {
        const toValue = this.value;
        Array.from(fromWarehouse.options).forEach(option => {
            if (option.value === toValue && option.value !== '') {
                option.disabled = true;
            } else {
                option.disabled = false;
            }
        });
    });
});
</script>
@endpush
@endsection

