<?php
    $locale = app()->getLocale();
    $isRTL = $locale === 'ar';
    $dir = $isRTL ? 'rtl' : 'ltr';
    $lang = $locale;
?>
<!DOCTYPE html>
<html lang="<?php echo e($lang); ?>" dir="<?php echo e($dir); ?>">
<head>
    <meta charset="UTF-8">
    <meta name="viewport" content="width=device-width, initial-scale=1.0">
    <meta name="csrf-token" content="<?php echo e(csrf_token()); ?>">
    <title><?php echo e(__('messages.login')); ?> - Gestock Pro</title>
    <link rel="stylesheet" href="<?php echo e(asset('lib/fonts/google-fonts.css')); ?>">
    <link href="<?php echo e(asset('lib/css/bootstrap.min.css')); ?>" rel="stylesheet">
    <link rel="stylesheet" href="<?php echo e(asset('lib/icons/bootstrap-icons/bootstrap-icons.css')); ?>">
    <link rel="stylesheet" href="<?php echo e(asset('lib/icons/flag-icons/flag-icons.min.css')); ?>">
    <link rel="stylesheet" href="https://cdn.jsdelivr.net/npm/flag-icons@7.2.3/css/flag-icons.min.css">
    <style>
        <?php
            $fontFamily = $isRTL ? "'Cairo', 'DejaVu Sans', 'Segoe UI', Tahoma, Geneva, Verdana, sans-serif" : "'Cabin', 'DejaVu Sans', 'Segoe UI', Tahoma, Geneva, Verdana, sans-serif";
        ?>
        
        * {
            margin: 0;
            padding: 0;
            box-sizing: border-box;
        }
        
        <?php if($isRTL): ?>
        * {
            font-family: 'Cairo', 'DejaVu Sans', 'Segoe UI', Tahoma, Geneva, Verdana, sans-serif !important;
        }
        <?php else: ?>
        * {
            font-family: 'Cabin', 'DejaVu Sans', 'Segoe UI', Tahoma, Geneva, Verdana, sans-serif !important;
        }
        <?php endif; ?>
        
        body {
            background: linear-gradient(135deg, #667eea 0%, #764ba2 100%);
            min-height: 100vh;
            display: flex;
            align-items: center;
            justify-content: center;
            padding: 20px;
            position: relative;
            overflow-x: hidden;
        }
        
        body::before {
            content: '';
            position: absolute;
            top: 0;
            left: 0;
            right: 0;
            bottom: 0;
            background: url('data:image/svg+xml,<svg width="100" height="100" xmlns="http://www.w3.org/2000/svg"><circle cx="50" cy="50" r="2" fill="rgba(255,255,255,0.1)"/></svg>');
            opacity: 0.3;
            animation: float 20s infinite linear;
        }
        
        @keyframes float {
            0% { transform: translateY(0); }
            100% { transform: translateY(-100px); }
        }
        
        .login-container {
            width: 100%;
            max-width: 450px;
            position: relative;
            z-index: 1;
            animation: slideUp 0.6s ease-out;
        }
        
        @keyframes slideUp {
            from {
                opacity: 0;
                transform: translateY(30px);
            }
            to {
                opacity: 1;
                transform: translateY(0);
            }
        }
        
        .login-card {
            background: white;
            border-radius: 20px;
            box-shadow: 0 20px 60px rgba(0,0,0,0.3);
            overflow: hidden;
        }
        
        .login-header {
            background: linear-gradient(135deg, #667eea 0%, #764ba2 100%);
            color: white;
            padding: 25px 30px;
            text-align: center;
        }
        
        .login-header .logo-icon {
            width: 70px;
            height: 70px;
            background: rgba(255,255,255,0.2);
            border-radius: 50%;
            display: flex;
            align-items: center;
            justify-content: center;
            margin: 0 auto 15px;
            font-size: 35px;
        }
        
        .login-header h4 {
            font-weight: 700;
            font-size: 1.5rem;
            margin-bottom: 8px;
        }
        
        .login-header p {
            opacity: 0.9;
            font-size: 0.9rem;
            margin-bottom: 0;
        }
        
        .language-switcher {
            padding: 12px 30px;
            background: rgba(102, 126, 234, 0.1);
            display: flex !important;
            justify-content: center;
            gap: 8px;
            flex-wrap: wrap;
            visibility: visible !important;
            opacity: 1 !important;
        }
        
        .language-switcher .btn {
            padding: 8px 15px;
            font-size: 0.9rem;
            border-radius: 8px;
            transition: all 0.3s;
            display: inline-flex !important;
            align-items: center;
            gap: 6px;
            visibility: visible !important;
            opacity: 1 !important;
            min-width: auto;
            background-color: white !important;
            color: #667eea !important;
            border: 2px solid white !important;
        }
        
        .language-switcher .btn:hover {
            background-color: rgba(255,255,255,0.9) !important;
            color: #764ba2 !important;
        }
        
        .language-switcher .btn.active {
            background-color: white !important;
            color: #667eea !important;
            font-weight: 600;
        }
        
        .language-switcher .btn:hover {
            transform: translateY(-2px);
        }
        
        .language-switcher .fi {
            font-size: 1.2rem !important;
            margin: 0 !important;
            vertical-align: middle;
            display: inline-block !important;
            width: 1.2em !important;
            height: 1.2em !important;
            border-radius: 2px;
            box-shadow: 0 1px 3px rgba(0,0,0,0.1);
            background-size: cover !important;
            background-position: center !important;
            background-repeat: no-repeat !important;
        }
        
        .login-body {
            padding: 25px 30px;
        }
        
        .form-label {
            font-weight: 600;
            color: #2c3e50;
            margin-bottom: 6px;
            font-size: 0.9rem;
        }
        
        .form-control {
            border-radius: 10px;
            border: 2px solid #e9ecef;
            padding: 10px 15px;
            font-size: 0.95rem;
            transition: all 0.3s;
        }
        
        .form-control:focus {
            border-color: #667eea;
            box-shadow: 0 0 0 0.2rem rgba(102, 126, 234, 0.25);
        }
        
        .form-check {
            margin: 15px 0;
        }
        
        .form-check-input {
            border-radius: 4px;
            border: 2px solid #e9ecef;
        }
        
        .form-check-input:checked {
            background-color: #667eea;
            border-color: #667eea;
        }
        
        .btn-primary {
            background: linear-gradient(135deg, #667eea 0%, #764ba2 100%);
            border: none;
            border-radius: 10px;
            padding: 10px;
            font-weight: 600;
            font-size: 0.95rem;
            transition: all 0.3s;
            box-shadow: 0 4px 15px rgba(102, 126, 234, 0.3);
        }
        
        .btn-primary:hover {
            transform: translateY(-2px);
            box-shadow: 0 6px 20px rgba(102, 126, 234, 0.4);
        }
        
        .forgot-password-link {
            text-align: center;
            margin-top: 15px;
        }
        
        .forgot-password-link a {
            color: #667eea;
            text-decoration: none;
            font-weight: 500;
            transition: all 0.3s;
        }
        
        .forgot-password-link a:hover {
            color: #764ba2;
            text-decoration: underline;
        }
        
        .invalid-feedback {
            display: block;
            margin-top: 5px;
            font-size: 0.875rem;
        }
        
        @media (max-width: 768px) {
            .login-body {
                padding: 30px 25px;
            }
            
            .login-header {
                padding: 25px 20px;
            }
            
            .login-header h4 {
                font-size: 1.5rem;
            }
        }
    </style>
</head>
<body>
    <div class="login-container">
        <div class="login-card">
            <div class="login-header">
                <div class="logo-icon">
                    <i class="bi bi-box-seam"></i>
                </div>
                <h4>Gestock Pro</h4>
                <p><?php echo e(__('messages.welcome_back') ?? 'Welcome Back'); ?></p>
            </div>
            
            <div class="language-switcher">
                <?php
                    $locales = [
                        'en' => ['name' => 'English', 'flag' => 'gb'],
                        'ar' => ['name' => 'العربية', 'flag' => 'ma'],
                        'fr' => ['name' => 'Français', 'flag' => 'fr'],
                    ];
                ?>
                <?php $__currentLoopData = $locales; $__env->addLoop($__currentLoopData); foreach($__currentLoopData as $code => $locale): $__env->incrementLoopIndices(); $loop = $__env->getLastLoop(); ?>
                    <a href="<?php echo e(route('language.switch', $code)); ?>" class="btn btn-sm language-btn <?php echo e(app()->getLocale() === $code ? 'active' : ''); ?>" style="display: inline-flex !important; align-items: center; gap: 8px; visibility: visible !important; opacity: 1 !important;">
                        <span class="fi fi-<?php echo e($locale['flag']); ?>" style="display: inline-block !important; width: 1.2em !important; height: 1.2em !important; font-size: 1.2rem !important;"></span> 
                        <span><?php echo e($locale['name']); ?></span>
                    </a>
                <?php endforeach; $__env->popLoop(); $loop = $__env->getLastLoop(); ?>
            </div>
            
            <div class="login-body">
                <form method="POST" action="<?php echo e(route('login')); ?>">
                    <?php echo csrf_field(); ?>
                    <div class="mb-3">
                        <label for="email" class="form-label">
                            <i class="bi bi-envelope"></i> <?php echo e(__('messages.email')); ?>

                        </label>
                        <input type="email" class="form-control <?php $__errorArgs = ['email'];
$__bag = $errors->getBag($__errorArgs[1] ?? 'default');
if ($__bag->has($__errorArgs[0])) :
if (isset($message)) { $__messageOriginal = $message; }
$message = $__bag->first($__errorArgs[0]); ?> is-invalid <?php unset($message);
if (isset($__messageOriginal)) { $message = $__messageOriginal; }
endif;
unset($__errorArgs, $__bag); ?>" id="email" name="email" value="<?php echo e(old('email')); ?>" required autofocus placeholder="<?php echo e(__('messages.email')); ?>">
                        <?php $__errorArgs = ['email'];
$__bag = $errors->getBag($__errorArgs[1] ?? 'default');
if ($__bag->has($__errorArgs[0])) :
if (isset($message)) { $__messageOriginal = $message; }
$message = $__bag->first($__errorArgs[0]); ?>
                            <div class="invalid-feedback"><?php echo e($message); ?></div>
                        <?php unset($message);
if (isset($__messageOriginal)) { $message = $__messageOriginal; }
endif;
unset($__errorArgs, $__bag); ?>
                    </div>
                    
                    <div class="mb-3">
                        <label for="password" class="form-label">
                            <i class="bi bi-lock"></i> <?php echo e(__('messages.password')); ?>

                        </label>
                        <input type="password" class="form-control <?php $__errorArgs = ['password'];
$__bag = $errors->getBag($__errorArgs[1] ?? 'default');
if ($__bag->has($__errorArgs[0])) :
if (isset($message)) { $__messageOriginal = $message; }
$message = $__bag->first($__errorArgs[0]); ?> is-invalid <?php unset($message);
if (isset($__messageOriginal)) { $message = $__messageOriginal; }
endif;
unset($__errorArgs, $__bag); ?>" id="password" name="password" required placeholder="<?php echo e(__('messages.password')); ?>">
                        <?php $__errorArgs = ['password'];
$__bag = $errors->getBag($__errorArgs[1] ?? 'default');
if ($__bag->has($__errorArgs[0])) :
if (isset($message)) { $__messageOriginal = $message; }
$message = $__bag->first($__errorArgs[0]); ?>
                            <div class="invalid-feedback"><?php echo e($message); ?></div>
                        <?php unset($message);
if (isset($__messageOriginal)) { $message = $__messageOriginal; }
endif;
unset($__errorArgs, $__bag); ?>
                    </div>
                    
                    <div class="form-check">
                        <input type="checkbox" class="form-check-input" id="remember" name="remember">
                        <label class="form-check-label" for="remember"><?php echo e(__('messages.remember_me')); ?></label>
                    </div>
                    
                    <button type="submit" class="btn btn-primary w-100">
                        <i class="bi bi-box-arrow-in-right"></i> <?php echo e(__('messages.login')); ?>

                    </button>
                </form>
                
                <div class="forgot-password-link">
                    <a href="<?php echo e(route('password.request')); ?>">
                        <i class="bi bi-question-circle"></i> <?php echo e(__('messages.forgot_password')); ?>

                    </a>
                </div>
            </div>
        </div>
    </div>
    
    <script src="<?php echo e(asset('lib/js/bootstrap.bundle.min.js')); ?>"></script>
</body>
</html>
<?php /**PATH C:\xampp\htdocs\GestionStock\resources\views/auth/login.blade.php ENDPATH**/ ?>