

<?php $__env->startSection('title', trans('messages.quotations')); ?>

<?php $__env->startSection('content'); ?>
<?php
    $sort = request()->get('sort', 'created_at');
    $direction = request()->get('direction', 'desc');
?>
<div class="page-header">
    <h2><?php echo e(trans('messages.quotations')); ?></h2>
    <div class="d-flex gap-2">
        <?php if (app(\Illuminate\Contracts\Auth\Access\Gate::class)->check('invoices.create')): ?>
            <a href="<?php echo e(route('quotations.create')); ?>" class="btn btn-primary">
                <i class="bi bi-file-earmark-text"></i> <?php echo e(trans('messages.create_quotation')); ?>

            </a>
        <?php endif; ?>
    </div>
</div>

<div class="card">
    <div class="card-body">
        <?php if (app(\Illuminate\Contracts\Auth\Access\Gate::class)->check('invoices.bulk_delete')): ?>
        <div class="mb-3">
            <button type="button" id="delete-selected-btn" class="btn btn-danger" disabled onclick="bulkDeleteQuotations()">
                <i class="bi bi-trash"></i> <?php echo e(trans('messages.delete_selected')); ?>

            </button>
        </div>
        <?php endif; ?>

        <form method="GET" action="<?php echo e(route('quotations.index')); ?>" class="mb-3">
            <div class="row g-3">
                <div class="col-md-3">
                    <input type="text" name="search" class="form-control" placeholder="<?php echo e(trans('messages.search')); ?>..." value="<?php echo e(request('search')); ?>">
                </div>
                <div class="col-md-2">
                    <input type="date" name="date_from" class="form-control" placeholder="<?php echo e(trans('messages.from_date')); ?>" value="<?php echo e(request('date_from')); ?>">
                </div>
                <div class="col-md-2">
                    <input type="date" name="date_to" class="form-control" placeholder="<?php echo e(trans('messages.to_date')); ?>" value="<?php echo e(request('date_to')); ?>">
                </div>
                <div class="col-md-2">
                    <button type="submit" class="btn btn-secondary w-100"><?php echo e(trans('messages.filter')); ?></button>
                </div>
            </div>
        </form>

        <div class="table-responsive">
            <table class="table table-hover">
                <thead>
                    <tr>
                        <?php if (app(\Illuminate\Contracts\Auth\Access\Gate::class)->check('invoices.bulk_delete')): ?>
                        <th style="width: 40px;">
                            <input type="checkbox" id="select-all-quotations" title="<?php echo e(trans('messages.select_all')); ?>">
                        </th>
                        <?php endif; ?>
                        <th>
                            <a href="<?php echo e(request()->fullUrlWithQuery(['sort' => 'invoice_number', 'direction' => ($sort === 'invoice_number' && $direction === 'asc') ? 'desc' : 'asc'])); ?>" class="text-decoration-none text-dark">
                                <?php echo e(trans('messages.quotation_number')); ?>

                                <?php if($sort === 'invoice_number'): ?>
                                    <i class="bi bi-arrow-<?php echo e($direction === 'asc' ? 'up' : 'down'); ?>"></i>
                                <?php else: ?>
                                    <i class="bi bi-arrow-down-up text-muted"></i>
                                <?php endif; ?>
                            </a>
                        </th>
                        <th><?php echo e(trans('messages.customer')); ?></th>
                        <th>
                            <a href="<?php echo e(request()->fullUrlWithQuery(['sort' => 'created_at', 'direction' => ($sort === 'created_at' && $direction === 'asc') ? 'desc' : 'asc'])); ?>" class="text-decoration-none text-dark">
                                <?php echo e(trans('messages.date')); ?>

                                <?php if($sort === 'created_at'): ?>
                                    <i class="bi bi-arrow-<?php echo e($direction === 'asc' ? 'up' : 'down'); ?>"></i>
                                <?php else: ?>
                                    <i class="bi bi-arrow-down-up text-muted"></i>
                                <?php endif; ?>
                            </a>
                        </th>
                        <th>
                            <a href="<?php echo e(request()->fullUrlWithQuery(['sort' => 'total', 'direction' => ($sort === 'total' && $direction === 'asc') ? 'desc' : 'asc'])); ?>" class="text-decoration-none text-dark">
                                <?php echo e(trans('messages.total')); ?>

                                <?php if($sort === 'total'): ?>
                                    <i class="bi bi-arrow-<?php echo e($direction === 'asc' ? 'up' : 'down'); ?>"></i>
                                <?php else: ?>
                                    <i class="bi bi-arrow-down-up text-muted"></i>
                                <?php endif; ?>
                            </a>
                        </th>
                        <th><?php echo e(trans('messages.actions')); ?></th>
                    </tr>
                </thead>
                <tbody>
                    <?php $__empty_1 = true; $__currentLoopData = $quotations; $__env->addLoop($__currentLoopData); foreach($__currentLoopData as $quotation): $__env->incrementLoopIndices(); $loop = $__env->getLastLoop(); $__empty_1 = false; ?>
                    <tr>
                        <?php if (app(\Illuminate\Contracts\Auth\Access\Gate::class)->check('invoices.bulk_delete')): ?>
                        <td>
                            <input type="checkbox" class="quotation-checkbox" value="<?php echo e($quotation->id); ?>">
                        </td>
                        <?php endif; ?>
                                    <td><a href="<?php echo e(route('quotations.show', $quotation)); ?>"><?php echo e($quotation->invoice_number); ?></a></td>
                        <td><?php echo e($quotation->customer?->name ?? $quotation->customer_name); ?></td>
                        <td><?php echo e($quotation->created_at->format('Y-m-d')); ?></td>
                        <td><?php echo e(format_currency($quotation->total)); ?></td>
                        <td>
                            <a href="<?php echo e(route('quotations.show', $quotation)); ?>" class="btn btn-sm btn-info"><?php echo e(trans('messages.view')); ?></a>
                            <a href="<?php echo e(route('invoices.devis', $quotation)); ?>" class="btn btn-sm btn-primary" target="_blank">
                                <i class="bi bi-printer"></i> <?php echo e(trans('messages.print_quotation')); ?>

                            </a>
                            <?php if (app(\Illuminate\Contracts\Auth\Access\Gate::class)->check('invoices.finalize')): ?>
                            <form action="<?php echo e(route('invoices.convert-quotation-to-invoice', $quotation)); ?>" method="POST" class="d-inline">
                                <?php echo csrf_field(); ?>
                                <button type="submit" class="btn btn-sm btn-success" onclick="return confirm('<?php echo e(trans('messages.confirm_convert_quotation_to_invoice')); ?>')">
                                    <i class="bi bi-receipt"></i> <?php echo e(trans('messages.convert_to_invoice')); ?>

                                </button>
                            </form>
                            <?php endif; ?>
                            <?php if (app(\Illuminate\Contracts\Auth\Access\Gate::class)->check('invoices.delete')): ?>
                            <form action="<?php echo e(route('quotations.destroy', $quotation)); ?>" method="POST" class="d-inline" onsubmit="return confirm('<?php echo e(trans('messages.confirm_delete')); ?>')">
                                <?php echo csrf_field(); ?>
                                <?php echo method_field('DELETE'); ?>
                                <button type="submit" class="btn btn-sm btn-danger"><?php echo e(trans('messages.delete')); ?></button>
                            </form>
                            <?php endif; ?>
                        </td>
                    </tr>
                    <?php endforeach; $__env->popLoop(); $loop = $__env->getLastLoop(); if ($__empty_1): ?>
                    <tr>
                        <td colspan="<?php echo e(auth()->user()->can('invoices.bulk_delete') ? '6' : '5'); ?>" class="text-center"><?php echo e(trans('messages.no_quotations_found')); ?></td>
                    </tr>
                    <?php endif; ?>
                </tbody>
            </table>
        </div>

        <div class="mt-3">
            <?php echo e($quotations->links()); ?>

        </div>
    </div>
</div>

<?php if (app(\Illuminate\Contracts\Auth\Access\Gate::class)->check('invoices.bulk_delete')): ?>
<?php $__env->startPush('scripts'); ?>
<script>
document.getElementById('select-all-quotations')?.addEventListener('change', function() {
    const checkboxes = document.querySelectorAll('.quotation-checkbox');
    checkboxes.forEach(cb => cb.checked = this.checked);
    updateDeleteButton();
});

document.querySelectorAll('.quotation-checkbox').forEach(checkbox => {
    checkbox.addEventListener('change', updateDeleteButton);
});

function updateDeleteButton() {
    const checked = document.querySelectorAll('.quotation-checkbox:checked').length;
    const btn = document.getElementById('delete-selected-btn');
    if (btn) {
        btn.disabled = checked === 0;
    }
}

function bulkDeleteQuotations() {
    const selected = Array.from(document.querySelectorAll('.quotation-checkbox:checked')).map(cb => cb.value);
    if (selected.length === 0) return;
    
    if (confirm('<?php echo e(trans('messages.confirm_delete_selected')); ?>: ' + selected.length + ' <?php echo e(trans('messages.items')); ?>?')) {
        const form = document.createElement('form');
        form.method = 'POST';
        form.action = '<?php echo e(route('quotations.bulk-delete')); ?>';
        form.innerHTML = `
            <?php echo csrf_field(); ?>
            <?php echo method_field('POST'); ?>
            ${selected.map(id => `<input type="hidden" name="selected_ids[]" value="${id}">`).join('')}
        `;
        document.body.appendChild(form);
        form.submit();
    }
}
</script>
<?php $__env->stopPush(); ?>
<?php endif; ?>
<?php $__env->stopSection(); ?>


<?php echo $__env->make('layouts.master', \Illuminate\Support\Arr::except(get_defined_vars(), ['__data', '__path']))->render(); ?><?php /**PATH C:\xampp\htdocs\GestionStock\resources\views/quotations/index.blade.php ENDPATH**/ ?>