

<?php $__env->startSection('title', trans('messages.purchase_orders')); ?>

<?php $__env->startSection('content'); ?>
<div class="page-header">
    <h2><?php echo e(trans('messages.purchase_orders')); ?></h2>
    <div>
        <a href="<?php echo e(route('purchase-orders.create')); ?>" class="btn btn-primary">
            <i class="bi bi-plus-circle"></i> <?php echo e(trans('messages.create_purchase_order')); ?>

        </a>
    </div>
</div>

<div class="card">
    <div class="card-body">
        <?php if (app(\Illuminate\Contracts\Auth\Access\Gate::class)->check('purchase-orders.bulk_delete')): ?>
        <div class="mb-3 d-flex gap-2">
            <button type="button" id="delete-selected-btn" class="btn btn-danger" disabled onclick="bulkDeletePurchaseOrders()">
                <i class="bi bi-trash"></i> <?php echo e(trans('messages.delete_selected')); ?>

            </button>
        </div>
        <?php endif; ?>

        <form method="GET" action="<?php echo e(route('purchase-orders.index')); ?>" class="mb-3">
            <div class="row g-3">
                <div class="col-md-4">
                    <input type="text" name="search" class="form-control" placeholder="<?php echo e(trans('messages.search')); ?>..." value="<?php echo e(request('search')); ?>">
                </div>
                <div class="col-md-3">
                    <select name="status" class="form-select">
                        <option value=""><?php echo e(trans('messages.all_statuses')); ?></option>
                        <option value="draft" <?php echo e(request('status') == 'draft' ? 'selected' : ''); ?>><?php echo e(trans('messages.draft')); ?></option>
                        <option value="pending" <?php echo e(request('status') == 'pending' ? 'selected' : ''); ?>><?php echo e(trans('messages.pending')); ?></option>
                        <option value="approved" <?php echo e(request('status') == 'approved' ? 'selected' : ''); ?>><?php echo e(trans('messages.approved')); ?></option>
                        <option value="completed" <?php echo e(request('status') == 'completed' ? 'selected' : ''); ?>><?php echo e(trans('messages.completed')); ?></option>
                    </select>
                </div>
                <div class="col-md-2">
                    <button type="submit" class="btn btn-secondary w-100"><?php echo e(trans('messages.filter')); ?></button>
                </div>
            </div>
        </form>

        <div class="table-responsive">
            <table class="table table-hover">
                <thead>
                    <tr>
                        <?php if (app(\Illuminate\Contracts\Auth\Access\Gate::class)->check('purchase-orders.bulk_delete')): ?>
                        <th style="width: 40px;">
                            <input type="checkbox" id="select-all-orders" title="<?php echo e(trans('messages.select_all')); ?>">
                        </th>
                        <?php endif; ?>
                        <th><?php echo e(trans('messages.order_number')); ?></th>
                        <th><?php echo e(trans('messages.supplier')); ?></th>
                        <th><?php echo e(trans('messages.total_amount')); ?></th>
                        <th><?php echo e(trans('messages.expected_delivery_date')); ?></th>
                        <th><?php echo e(trans('messages.status')); ?></th>
                        <th><?php echo e(trans('messages.generation_type')); ?></th>
                        <th><?php echo e(trans('messages.created_at')); ?></th>
                        <th><?php echo e(trans('messages.actions')); ?></th>
                    </tr>
                </thead>
                <tbody>
                    <?php $__empty_1 = true; $__currentLoopData = $orders; $__env->addLoop($__currentLoopData); foreach($__currentLoopData as $order): $__env->incrementLoopIndices(); $loop = $__env->getLastLoop(); $__empty_1 = false; ?>
                    <tr>
                        <?php if (app(\Illuminate\Contracts\Auth\Access\Gate::class)->check('purchase-orders.bulk_delete')): ?>
                        <td>
                            <?php if($order->isDraft()): ?>
                                <input type="checkbox" class="order-checkbox" value="<?php echo e($order->id); ?>">
                            <?php endif; ?>
                        </td>
                        <?php endif; ?>
                        <td><a href="<?php echo e(route('purchase-orders.show', $order)); ?>"><?php echo e($order->order_number); ?></a></td>
                        <td><?php echo e($order->supplier?->name ?? '-'); ?></td>
                        <td><?php echo e(format_currency($order->total_amount)); ?></td>
                        <td><?php echo e($order->expected_delivery_date ? $order->expected_delivery_date->format('Y-m-d') : '-'); ?></td>
                        <td>
                            <?php
                                $badgeClass = match($order->status) {
                                    'draft' => 'secondary',
                                    'pending' => 'warning',
                                    'approved' => 'success',
                                    'completed' => 'primary',
                                    'rejected' => 'danger',
                                    'cancelled' => 'dark',
                                    default => 'secondary'
                                };
                            ?>
                            <span class="badge bg-<?php echo e($badgeClass); ?>"><?php echo e(trans('messages.' . $order->status)); ?></span>
                        </td>
                        <td>
                            <span class="badge bg-<?php echo e($order->generation_type === 'auto' ? 'info' : 'secondary'); ?>">
                                <?php echo e(trans('messages.' . $order->generation_type)); ?>

                            </span>
                        </td>
                        <td><?php echo e($order->created_at->format('Y-m-d')); ?></td>
                        <td>
                            <a href="<?php echo e(route('purchase-orders.show', $order)); ?>" class="btn btn-sm btn-info"><?php echo e(trans('messages.view')); ?></a>
                            <?php if($order->isDraft()): ?>
                                <a href="<?php echo e(route('purchase-orders.edit', $order)); ?>" class="btn btn-sm btn-warning"><?php echo e(trans('messages.edit')); ?></a>
                            <?php endif; ?>
                            <?php if($order->status === 'pending'): ?>
                                <form action="<?php echo e(route('purchase-orders.approve', $order)); ?>" method="POST" class="d-inline">
                                    <?php echo csrf_field(); ?>
                                    <button type="submit" class="btn btn-sm btn-success"><?php echo e(trans('messages.approve')); ?></button>
                                </form>
                            <?php endif; ?>
                            <?php if($order->isDraft()): ?>
                                <form action="<?php echo e(route('purchase-orders.destroy', $order)); ?>" method="POST" class="d-inline" onsubmit="return confirm('<?php echo e(trans('messages.confirm_delete')); ?>')">
                                    <?php echo csrf_field(); ?>
                                    <?php echo method_field('DELETE'); ?>
                                    <button type="submit" class="btn btn-sm btn-danger"><?php echo e(trans('messages.delete')); ?></button>
                                </form>
                            <?php endif; ?>
                        </td>
                    </tr>
                    <?php endforeach; $__env->popLoop(); $loop = $__env->getLastLoop(); if ($__empty_1): ?>
                    <tr>
                        <td colspan="<?php echo e(auth()->user()->can('purchase-orders.bulk_delete') ? '9' : '8'); ?>" class="text-center"><?php echo e(trans('messages.no_purchase_orders_found')); ?></td>
                    </tr>
                    <?php endif; ?>
                </tbody>
            </table>
        </div>

        <div class="mt-3">
            <?php echo e($orders->links()); ?>

        </div>
    </div>
</div>

<?php if (app(\Illuminate\Contracts\Auth\Access\Gate::class)->check('purchase-orders.bulk_delete')): ?>
<?php $__env->startPush('scripts'); ?>
<script>
document.getElementById('select-all-orders')?.addEventListener('change', function() {
    const checkboxes = document.querySelectorAll('.order-checkbox');
    checkboxes.forEach(cb => cb.checked = this.checked);
    updateDeleteButton();
});

document.querySelectorAll('.order-checkbox').forEach(checkbox => {
    checkbox.addEventListener('change', updateDeleteButton);
});

function updateDeleteButton() {
    const checked = document.querySelectorAll('.order-checkbox:checked').length;
    const btn = document.getElementById('delete-selected-btn');
    if (btn) {
        btn.disabled = checked === 0;
    }
}

function bulkDeletePurchaseOrders() {
    const selected = Array.from(document.querySelectorAll('.order-checkbox:checked')).map(cb => cb.value);
    if (selected.length === 0) {
        alert('<?php echo e(trans('messages.no_items_selected')); ?>');
        return;
    }
    
    if (confirm('<?php echo e(trans('messages.confirm_bulk_delete_message')); ?>: ' + selected.length + ' <?php echo e(trans('messages.items')); ?>?')) {
        const form = document.createElement('form');
        form.method = 'POST';
        form.action = '<?php echo e(route('purchase-orders.bulk-delete')); ?>';
        
        // Add CSRF token
        const csrfToken = document.querySelector('meta[name="csrf-token"]')?.getAttribute('content');
        const csrfInput = document.createElement('input');
        csrfInput.type = 'hidden';
        csrfInput.name = '_token';
        csrfInput.value = csrfToken || '<?php echo e(csrf_token()); ?>';
        form.appendChild(csrfInput);
        
        // Add selected IDs
        selected.forEach(id => {
            const input = document.createElement('input');
            input.type = 'hidden';
            input.name = 'selected_ids[]';
            input.value = id;
            form.appendChild(input);
        });
        
        document.body.appendChild(form);
        form.submit();
    }
}
</script>
<?php $__env->stopPush(); ?>
<?php endif; ?>
<?php $__env->stopSection(); ?>


<?php echo $__env->make('layouts.master', \Illuminate\Support\Arr::except(get_defined_vars(), ['__data', '__path']))->render(); ?><?php /**PATH C:\xampp\htdocs\GestionStock\resources\views/purchase-orders/index.blade.php ENDPATH**/ ?>