

<?php $__env->startSection('title', trans('messages.permissions_management')); ?>

<?php $__env->startSection('content'); ?>
<div class="page-header">
    <h2><?php echo e(trans('messages.permissions_management')); ?></h2>
</div>

<div class="row g-3 mb-4">
    <!-- Users List -->
    <div class="col-md-12">
        <div class="card">
            <div class="card-header">
                <h5 class="mb-0"><?php echo e(trans('messages.users')); ?></h5>
            </div>
            <div class="card-body">
                <div class="table-responsive">
                    <table class="table table-striped">
                        <thead>
                            <tr>
                                <th><?php echo e(trans('messages.name')); ?></th>
                                <th><?php echo e(trans('messages.email')); ?></th>
                                <th><?php echo e(trans('messages.roles')); ?></th>
                                <th><?php echo e(trans('messages.permissions')); ?></th>
                                <th><?php echo e(trans('messages.actions')); ?></th>
                            </tr>
                        </thead>
                        <tbody>
                            <?php $__empty_1 = true; $__currentLoopData = $users; $__env->addLoop($__currentLoopData); foreach($__currentLoopData as $user): $__env->incrementLoopIndices(); $loop = $__env->getLastLoop(); $__empty_1 = false; ?>
                            <tr>
                                <td><?php echo e($user->name); ?></td>
                                <td><?php echo e($user->email); ?></td>
                                <td>
                                    <?php $__currentLoopData = $user->roles; $__env->addLoop($__currentLoopData); foreach($__currentLoopData as $role): $__env->incrementLoopIndices(); $loop = $__env->getLastLoop(); ?>
                                        <span class="badge bg-primary"><?php echo e($role->name); ?></span>
                                    <?php endforeach; $__env->popLoop(); $loop = $__env->getLastLoop(); ?>
                                </td>
                                <td>
                                    <?php
                                        $directPermissions = $user->permissions->pluck('name')->toArray();
                                        $rolePermissions = $user->getAllPermissions()->pluck('name')->toArray();
                                        $customPermissions = array_diff($directPermissions, $rolePermissions);
                                    ?>
                                    <?php if(count($customPermissions) > 0): ?>
                                        <span class="badge bg-info"><?php echo e(count($customPermissions)); ?> <?php echo e(trans('messages.custom')); ?></span>
                                    <?php else: ?>
                                        <span class="text-muted">-</span>
                                    <?php endif; ?>
                                </td>
                                <td>
                                    <a href="<?php echo e(route('permissions.user', $user)); ?>" class="btn btn-sm btn-primary">
                                        <i class="bi bi-gear"></i> <?php echo e(trans('messages.manage')); ?>

                                    </a>
                                </td>
                            </tr>
                            <?php endforeach; $__env->popLoop(); $loop = $__env->getLastLoop(); if ($__empty_1): ?>
                            <tr>
                                <td colspan="5" class="text-center"><?php echo e(trans('messages.no_users_found')); ?></td>
                            </tr>
                            <?php endif; ?>
                        </tbody>
                    </table>
                </div>
                <div class="mt-3">
                    <?php echo e($users->links()); ?>

                </div>
            </div>
        </div>
    </div>
</div>

<div class="row g-3">
    <!-- Roles -->
    <div class="col-md-6">
        <div class="card">
            <div class="card-header">
                <h5 class="mb-0"><?php echo e(trans('messages.roles')); ?></h5>
            </div>
            <div class="card-body">
                <form method="POST" action="<?php echo e(route('permissions.role.create')); ?>" class="mb-3">
                    <?php echo csrf_field(); ?>
                    <div class="input-group">
                        <input type="text" name="name" class="form-control <?php $__errorArgs = ['name'];
$__bag = $errors->getBag($__errorArgs[1] ?? 'default');
if ($__bag->has($__errorArgs[0])) :
if (isset($message)) { $__messageOriginal = $message; }
$message = $__bag->first($__errorArgs[0]); ?> is-invalid <?php unset($message);
if (isset($__messageOriginal)) { $message = $__messageOriginal; }
endif;
unset($__errorArgs, $__bag); ?>" placeholder="<?php echo e(trans('messages.role_name')); ?>" value="<?php echo e(old('name')); ?>" required>
                        <button type="submit" class="btn btn-primary"><?php echo e(trans('messages.add')); ?></button>
                    </div>
                    <?php $__errorArgs = ['name'];
$__bag = $errors->getBag($__errorArgs[1] ?? 'default');
if ($__bag->has($__errorArgs[0])) :
if (isset($message)) { $__messageOriginal = $message; }
$message = $__bag->first($__errorArgs[0]); ?>
                        <div class="text-danger small mt-1"><?php echo e($message); ?></div>
                    <?php unset($message);
if (isset($__messageOriginal)) { $message = $__messageOriginal; }
endif;
unset($__errorArgs, $__bag); ?>
                </form>
                <div class="list-group">
                    <?php $__empty_1 = true; $__currentLoopData = $roles; $__env->addLoop($__currentLoopData); foreach($__currentLoopData as $role): $__env->incrementLoopIndices(); $loop = $__env->getLastLoop(); $__empty_1 = false; ?>
                    <div class="list-group-item">
                        <div class="d-flex justify-content-between align-items-center">
                            <div>
                                <strong><?php echo e($role->name); ?></strong>
                                <small class="text-muted d-block"><?php echo e($role->permissions->count()); ?> <?php echo e(trans('messages.permissions')); ?></small>
                            </div>
                            <div class="btn-group">
                                <button type="button" class="btn btn-sm btn-outline-primary" data-bs-toggle="modal" data-bs-target="#rolePermissionsModal<?php echo e($role->id); ?>">
                                    <i class="bi bi-gear"></i>
                                </button>
                                <?php
                                    $defaultRoles = ['Super Admin', 'Admin', 'Cashier', 'Warehouse'];
                                    $canDelete = !in_array($role->name, $defaultRoles);
                                ?>
                                <?php if($canDelete): ?>
                                <form method="POST" action="<?php echo e(route('permissions.role.destroy', $role)); ?>" class="d-inline" onsubmit="return confirm('<?php echo e(trans('messages.confirm_delete')); ?>');">
                                    <?php echo csrf_field(); ?>
                                    <?php echo method_field('DELETE'); ?>
                                    <button type="submit" class="btn btn-sm btn-outline-danger">
                                        <i class="bi bi-trash"></i>
                                    </button>
                                </form>
                                <?php endif; ?>
                            </div>
                        </div>
                    </div>

                    <!-- Role Permissions Modal -->
                    <div class="modal fade" id="rolePermissionsModal<?php echo e($role->id); ?>" tabindex="-1">
                        <div class="modal-dialog modal-lg">
                            <div class="modal-content">
                                <div class="modal-header">
                                    <h5 class="modal-title"><?php echo e(trans('messages.manage_permissions')); ?> - <?php echo e($role->name); ?></h5>
                                    <button type="button" class="btn-close" data-bs-dismiss="modal"></button>
                                </div>
                                <form method="POST" action="<?php echo e(route('permissions.role.permissions', $role)); ?>">
                                    <?php echo csrf_field(); ?>
                                    <div class="modal-body">
                                        <?php $__currentLoopData = $permissions; $__env->addLoop($__currentLoopData); foreach($__currentLoopData as $group => $groupPermissions): $__env->incrementLoopIndices(); $loop = $__env->getLastLoop(); ?>
                                        <div class="mb-3">
                                            <h6><?php echo e(ucfirst($group)); ?></h6>
                                            <div class="row">
                                                <?php $__currentLoopData = $groupPermissions; $__env->addLoop($__currentLoopData); foreach($__currentLoopData as $permission): $__env->incrementLoopIndices(); $loop = $__env->getLastLoop(); ?>
                                                <div class="col-md-6 mb-2">
                                                    <div class="form-check">
                                                        <input class="form-check-input" type="checkbox" name="permissions[]" 
                                                               value="<?php echo e($permission->id); ?>" 
                                                               id="role_perm_<?php echo e($role->id); ?>_<?php echo e($permission->id); ?>"
                                                               <?php echo e($role->hasPermissionTo($permission) ? 'checked' : ''); ?>>
                                                        <label class="form-check-label" for="role_perm_<?php echo e($role->id); ?>_<?php echo e($permission->id); ?>">
                                                            <?php echo e($permission->name); ?>

                                                        </label>
                                                    </div>
                                                </div>
                                                <?php endforeach; $__env->popLoop(); $loop = $__env->getLastLoop(); ?>
                                            </div>
                                        </div>
                                        <?php endforeach; $__env->popLoop(); $loop = $__env->getLastLoop(); ?>
                                    </div>
                                    <div class="modal-footer">
                                        <button type="button" class="btn btn-secondary" data-bs-dismiss="modal"><?php echo e(trans('messages.cancel')); ?></button>
                                        <button type="submit" class="btn btn-primary"><?php echo e(trans('messages.save')); ?></button>
                                    </div>
                                </form>
                            </div>
                        </div>
                    </div>
                    <?php endforeach; $__env->popLoop(); $loop = $__env->getLastLoop(); if ($__empty_1): ?>
                    <div class="list-group-item text-center text-muted"><?php echo e(trans('messages.no_roles_found')); ?></div>
                    <?php endif; ?>
                </div>
            </div>
        </div>
    </div>

    <!-- Permissions -->
    <div class="col-md-6">
        <div class="card">
            <div class="card-header">
                <h5 class="mb-0"><?php echo e(trans('messages.permissions')); ?></h5>
            </div>
            <div class="card-body">
                <form method="POST" action="<?php echo e(route('permissions.permission.create')); ?>" class="mb-3">
                    <?php echo csrf_field(); ?>
                    <div class="input-group">
                        <input type="text" name="name" class="form-control <?php $__errorArgs = ['name'];
$__bag = $errors->getBag($__errorArgs[1] ?? 'default');
if ($__bag->has($__errorArgs[0])) :
if (isset($message)) { $__messageOriginal = $message; }
$message = $__bag->first($__errorArgs[0]); ?> is-invalid <?php unset($message);
if (isset($__messageOriginal)) { $message = $__messageOriginal; }
endif;
unset($__errorArgs, $__bag); ?>" placeholder="<?php echo e(trans('messages.permission_name')); ?>" value="<?php echo e(old('name')); ?>" required>
                        <button type="submit" class="btn btn-primary"><?php echo e(trans('messages.add')); ?></button>
                    </div>
                    <?php $__errorArgs = ['name'];
$__bag = $errors->getBag($__errorArgs[1] ?? 'default');
if ($__bag->has($__errorArgs[0])) :
if (isset($message)) { $__messageOriginal = $message; }
$message = $__bag->first($__errorArgs[0]); ?>
                        <div class="text-danger small mt-1"><?php echo e($message); ?></div>
                    <?php unset($message);
if (isset($__messageOriginal)) { $message = $__messageOriginal; }
endif;
unset($__errorArgs, $__bag); ?>
                </form>
                <div class="accordion" id="permissionsAccordion">
                    <?php $__currentLoopData = $permissions; $__env->addLoop($__currentLoopData); foreach($__currentLoopData as $group => $groupPermissions): $__env->incrementLoopIndices(); $loop = $__env->getLastLoop(); ?>
                    <div class="accordion-item">
                        <h2 class="accordion-header">
                            <button class="accordion-button collapsed" type="button" data-bs-toggle="collapse" data-bs-target="#collapse<?php echo e($loop->index); ?>">
                                <?php echo e(ucfirst($group)); ?> (<?php echo e(count($groupPermissions)); ?>)
                            </button>
                        </h2>
                        <div id="collapse<?php echo e($loop->index); ?>" class="accordion-collapse collapse" data-bs-parent="#permissionsAccordion">
                            <div class="accordion-body">
                                <ul class="list-unstyled mb-0">
                                    <?php $__currentLoopData = $groupPermissions; $__env->addLoop($__currentLoopData); foreach($__currentLoopData as $permission): $__env->incrementLoopIndices(); $loop = $__env->getLastLoop(); ?>
                                    <li class="mb-2 d-flex justify-content-between align-items-center">
                                        <span><i class="bi bi-shield-check text-primary"></i> <?php echo e($permission->name); ?></span>
                                        <form method="POST" action="<?php echo e(route('permissions.permission.destroy', $permission)); ?>" class="d-inline" onsubmit="return confirm('<?php echo e(trans('messages.confirm_delete')); ?>');">
                                            <?php echo csrf_field(); ?>
                                            <?php echo method_field('DELETE'); ?>
                                            <button type="submit" class="btn btn-sm btn-outline-danger">
                                                <i class="bi bi-trash"></i>
                                            </button>
                                        </form>
                                    </li>
                                    <?php endforeach; $__env->popLoop(); $loop = $__env->getLastLoop(); ?>
                                </ul>
                            </div>
                        </div>
                    </div>
                    <?php endforeach; $__env->popLoop(); $loop = $__env->getLastLoop(); ?>
                </div>
            </div>
        </div>
    </div>
</div>
<?php $__env->stopSection(); ?>


<?php echo $__env->make('layouts.master', \Illuminate\Support\Arr::except(get_defined_vars(), ['__data', '__path']))->render(); ?><?php /**PATH C:\xampp\htdocs\GestionStock\resources\views/permissions/index.blade.php ENDPATH**/ ?>