

<?php $__env->startSection('title', trans('messages.products')); ?>

<?php $__env->startSection('content'); ?>
<?php
    $sort = request()->get('sort', 'created_at');
    $direction = request()->get('direction', 'desc');
?>
<div class="page-header">
    <h2><?php echo e(trans('messages.products')); ?></h2>
    <div>
        <?php if (app(\Illuminate\Contracts\Auth\Access\Gate::class)->check('products.create')): ?>
            <a href="<?php echo e(route('products.create')); ?>" class="btn btn-primary"><i class="bi bi-plus-circle"></i> <?php echo e(trans('messages.add_product')); ?></a>
        <?php endif; ?>
        <?php if (app(\Illuminate\Contracts\Auth\Access\Gate::class)->check('products.import')): ?>
            <a href="<?php echo e(route('products.import')); ?>" class="btn btn-success"><i class="bi bi-upload"></i> <?php echo e(trans('messages.import_products')); ?></a>
        <?php endif; ?>
        <?php if (app(\Illuminate\Contracts\Auth\Access\Gate::class)->check('products.reports')): ?>
            <a href="<?php echo e(route('products.reports')); ?>" class="btn btn-info"><i class="bi bi-graph-up"></i> <?php echo e(trans('messages.product_reports')); ?></a>
        <?php endif; ?>
        <?php if (app(\Illuminate\Contracts\Auth\Access\Gate::class)->check('products.view')): ?>
            <a href="<?php echo e(route('products.print_low_stock')); ?>" class="btn btn-warning" target="_blank"><i class="bi bi-printer"></i> <?php echo e(trans('messages.print_low_stock')); ?></a>
        <?php endif; ?>
    </div>
</div>

<div class="card">
    <div class="card-body">
        <form method="GET" action="<?php echo e(route('products.index')); ?>" class="mb-3">
            <div class="row g-3">
                <div class="col-md-4">
                    <input type="text" name="search" class="form-control" placeholder="<?php echo e(trans('messages.search')); ?>..." value="<?php echo e(request('search')); ?>">
                </div>
                <div class="col-md-3">
                    <select name="category_id" class="form-select">
                        <option value=""><?php echo e(trans('messages.all_categories')); ?></option>
                        <?php $__currentLoopData = $categories; $__env->addLoop($__currentLoopData); foreach($__currentLoopData as $category): $__env->incrementLoopIndices(); $loop = $__env->getLastLoop(); ?>
                            <option value="<?php echo e($category->id); ?>" <?php echo e(request('category_id') == $category->id ? 'selected' : ''); ?>><?php echo e($category->name); ?></option>
                        <?php endforeach; $__env->popLoop(); $loop = $__env->getLastLoop(); ?>
                    </select>
                </div>
                <div class="col-md-2">
                    <button type="submit" class="btn btn-secondary w-100"><?php echo e(trans('messages.filter')); ?></button>
                </div>
                <div class="col-md-3 text-end">
                    <?php if (app(\Illuminate\Contracts\Auth\Access\Gate::class)->check('products.export')): ?>
                        <a href="<?php echo e(route('products.export')); ?>" class="btn btn-success"><i class="bi bi-download"></i> <?php echo e(trans('messages.export_csv')); ?></a>
                    <?php endif; ?>
                </div>
            </div>
        </form>

        <?php if (app(\Illuminate\Contracts\Auth\Access\Gate::class)->check('products.bulk_delete')): ?>
        <div class="mb-3">
            <button type="button" id="delete-selected-btn" class="btn btn-danger" disabled>
                <i class="bi bi-trash"></i> <?php echo e(trans('messages.delete_selected')); ?>

            </button>
        </div>
        <?php endif; ?>

        <div class="table-responsive">
            <table class="table table-hover">
                    <thead>
                        <tr>
                            <?php if (app(\Illuminate\Contracts\Auth\Access\Gate::class)->check('products.bulk_delete')): ?>
                            <th style="width: 40px;">
                                <input type="checkbox" id="select-all" title="<?php echo e(trans('messages.select_all')); ?>">
                            </th>
                            <?php endif; ?>
                            <th>
                            <a href="<?php echo e(request()->fullUrlWithQuery(['sort' => 'sku', 'direction' => ($sort === 'sku' && $direction === 'asc') ? 'desc' : 'asc'])); ?>" class="text-decoration-none text-dark">
                                <?php echo e(trans('messages.sku')); ?>

                                <?php if($sort === 'sku'): ?>
                                    <i class="bi bi-arrow-<?php echo e($direction === 'asc' ? 'up' : 'down'); ?>"></i>
                                <?php else: ?>
                                    <i class="bi bi-arrow-down-up text-muted"></i>
                                <?php endif; ?>
                            </a>
                        </th>
                        <th>
                            <a href="<?php echo e(request()->fullUrlWithQuery(['sort' => 'name', 'direction' => ($sort === 'name' && $direction === 'asc') ? 'desc' : 'asc'])); ?>" class="text-decoration-none text-dark">
                                <?php echo e(trans('messages.name')); ?>

                                <?php if($sort === 'name'): ?>
                                    <i class="bi bi-arrow-<?php echo e($direction === 'asc' ? 'up' : 'down'); ?>"></i>
                                <?php else: ?>
                                    <i class="bi bi-arrow-down-up text-muted"></i>
                                <?php endif; ?>
                            </a>
                        </th>
                        <th><?php echo e(trans('messages.category')); ?></th>
                        <th>
                            <a href="<?php echo e(request()->fullUrlWithQuery(['sort' => 'stock_quantity', 'direction' => ($sort === 'stock_quantity' && $direction === 'asc') ? 'desc' : 'asc'])); ?>" class="text-decoration-none text-dark">
                                <?php echo e(trans('messages.stock')); ?>

                                <?php if($sort === 'stock_quantity'): ?>
                                    <i class="bi bi-arrow-<?php echo e($direction === 'asc' ? 'up' : 'down'); ?>"></i>
                                <?php else: ?>
                                    <i class="bi bi-arrow-down-up text-muted"></i>
                                <?php endif; ?>
                            </a>
                        </th>
                        <th>
                            <a href="<?php echo e(request()->fullUrlWithQuery(['sort' => 'purchase_price', 'direction' => ($sort === 'purchase_price' && $direction === 'asc') ? 'desc' : 'asc'])); ?>" class="text-decoration-none text-dark">
                                <?php echo e(trans('messages.purchase_price')); ?>

                                <?php if($sort === 'purchase_price'): ?>
                                    <i class="bi bi-arrow-<?php echo e($direction === 'asc' ? 'up' : 'down'); ?>"></i>
                                <?php else: ?>
                                    <i class="bi bi-arrow-down-up text-muted"></i>
                                <?php endif; ?>
                            </a>
                        </th>
                        <th>
                            <a href="<?php echo e(request()->fullUrlWithQuery(['sort' => 'selling_price', 'direction' => ($sort === 'selling_price' && $direction === 'asc') ? 'desc' : 'asc'])); ?>" class="text-decoration-none text-dark">
                                <?php echo e(trans('messages.selling_price')); ?>

                                <?php if($sort === 'selling_price'): ?>
                                    <i class="bi bi-arrow-<?php echo e($direction === 'asc' ? 'up' : 'down'); ?>"></i>
                                <?php else: ?>
                                    <i class="bi bi-arrow-down-up text-muted"></i>
                                <?php endif; ?>
                            </a>
                        </th>
                        <th><?php echo e(trans('messages.actions')); ?></th>
                    </tr>
                </thead>
                <tbody>
                    <?php $__empty_1 = true; $__currentLoopData = $products; $__env->addLoop($__currentLoopData); foreach($__currentLoopData as $product): $__env->incrementLoopIndices(); $loop = $__env->getLastLoop(); $__empty_1 = false; ?>
                    <tr>
                        <?php if (app(\Illuminate\Contracts\Auth\Access\Gate::class)->check('products.bulk_delete')): ?>
                        <td>
                            <input type="checkbox" class="item-checkbox" value="<?php echo e($product->id); ?>">
                        </td>
                        <?php endif; ?>
                        <td><?php echo e($product->sku); ?></td>
                        <td>
                            <a href="<?php echo e(route('products.show', $product)); ?>"><?php echo e($product->name); ?></a>
                        </td>
                        <td><?php echo e($product->category?->name ?? 'N/A'); ?></td>
                        <td>
                            <?php echo e($product->stock_quantity); ?>

                            <?php if($product->isLowStock()): ?>
                                <span class="badge bg-danger ms-2"><?php echo e(trans('messages.low_stock')); ?></span>
                            <?php endif; ?>
                        </td>
                        <td><?php echo e(format_currency($product->purchase_price)); ?></td>
                        <td><?php echo e(format_currency($product->selling_price)); ?></td>
                        <td>
                            <?php if (app(\Illuminate\Contracts\Auth\Access\Gate::class)->check('products.update')): ?>
                                <a href="<?php echo e(route('products.edit', $product)); ?>" class="btn btn-sm btn-warning" title="<?php echo e(trans('messages.edit')); ?>"><i class="bi bi-pencil"></i></a>
                            <?php endif; ?>
                            <?php if (app(\Illuminate\Contracts\Auth\Access\Gate::class)->check('products.delete')): ?>
                                <form action="<?php echo e(route('products.destroy', $product)); ?>" method="POST" class="d-inline delete-form">
                                    <?php echo csrf_field(); ?>
                                    <?php echo method_field('DELETE'); ?>
                                    <button type="submit" class="btn btn-sm btn-danger" title="<?php echo e(trans('messages.delete')); ?>" onclick="event.preventDefault(); confirmAction('<?php echo e(trans('messages.confirm_delete_product')); ?>', '<?php echo e(trans('messages.confirm_delete')); ?>', () => this.closest('form').submit()); return false;"><i class="bi bi-trash"></i></button>
                                </form>
                            <?php endif; ?>
                        </td>
                    </tr>
                    <?php endforeach; $__env->popLoop(); $loop = $__env->getLastLoop(); if ($__empty_1): ?>
                    <tr>
                        <td colspan="<?php echo e(auth()->user()->can('products.bulk_delete') ? '8' : '7'); ?>" class="text-center"><?php echo e(trans('messages.no_products_found')); ?></td>
                    </tr>
                    <?php endif; ?>
                </tbody>
            </table>
        </div>
        
        <!-- Hidden form for bulk delete -->
        <form id="bulk-delete-form" method="POST" action="<?php echo e(route('products.bulk_delete')); ?>" style="display: none;">
            <?php echo csrf_field(); ?>
        </form>

        <?php echo e($products->links()); ?>

    </div>
</div>

<?php echo $__env->make('partials.bulk-delete-modal', \Illuminate\Support\Arr::except(get_defined_vars(), ['__data', '__path']))->render(); ?>
<?php $__env->stopSection(); ?>

<?php echo $__env->make('layouts.master', \Illuminate\Support\Arr::except(get_defined_vars(), ['__data', '__path']))->render(); ?><?php /**PATH C:\xampp\htdocs\GestionStock\resources\views/products/index.blade.php ENDPATH**/ ?>