

<?php $__env->startSection('title', trans('messages.cash_flow_report')); ?>

<?php $__env->startSection('content'); ?>
<div class="page-header">
    <h2><?php echo e(trans('messages.cash_flow_report')); ?></h2>
    <div>
        <a href="<?php echo e(route('reports.cash-flow.print', request()->all())); ?>" target="_blank" class="btn btn-primary">
            <i class="bi bi-printer"></i> <?php echo e(trans('messages.print_report')); ?>

        </a>
        <a href="<?php echo e(route('reports.index')); ?>" class="btn btn-secondary">
            <i class="bi bi-arrow-left"></i> <?php echo e(trans('messages.back')); ?>

        </a>
    </div>
</div>

<div class="card mb-3">
    <div class="card-body">
        <form method="GET" action="<?php echo e(route('reports.cash-flow')); ?>">
            <div class="row g-3">
                <div class="col-md-4">
                    <label for="date_from" class="form-label"><?php echo e(trans('messages.from_date')); ?></label>
                    <input type="date" name="date_from" class="form-control" value="<?php echo e($dateFrom); ?>">
                </div>
                <div class="col-md-4">
                    <label for="date_to" class="form-label"><?php echo e(trans('messages.to_date')); ?></label>
                    <input type="date" name="date_to" class="form-control" value="<?php echo e($dateTo); ?>">
                </div>
                <div class="col-md-4">
                    <label class="form-label">&nbsp;</label>
                    <button type="submit" class="btn btn-primary w-100 d-block"><?php echo e(trans('messages.filter')); ?></button>
                </div>
            </div>
        </form>
    </div>
</div>

<div class="row g-3 mb-4">
    <div class="col-md-4">
        <div class="card text-white bg-success">
            <div class="card-body">
                <h5><?php echo e(trans('messages.cash_inflow')); ?></h5>
                <h3><?php echo e(format_currency($totalInflow)); ?></h3>
            </div>
        </div>
    </div>
    <div class="col-md-4">
        <div class="card text-white bg-danger">
            <div class="card-body">
                <h5><?php echo e(trans('messages.cash_outflow')); ?></h5>
                <h3><?php echo e(format_currency($totalOutflow)); ?></h3>
            </div>
        </div>
    </div>
    <div class="col-md-4">
        <div class="card text-white <?php echo e($netCashFlow >= 0 ? 'bg-primary' : 'bg-warning'); ?>">
            <div class="card-body">
                <h5><?php echo e(trans('messages.net_cash_flow')); ?></h5>
                <h3><?php echo e(format_currency($netCashFlow)); ?></h3>
            </div>
        </div>
    </div>
</div>

<div class="card">
    <div class="card-header">
        <h5 class="mb-0"><?php echo e(trans('messages.cash_flow_report')); ?></h5>
    </div>
    <div class="card-body">
        <div class="table-responsive">
            <table class="table table-striped">
                <thead>
                    <tr>
                        <th><?php echo e(trans('messages.date')); ?></th>
                        <th class="text-end"><?php echo e(trans('messages.cash_inflow')); ?></th>
                        <th class="text-end"><?php echo e(trans('messages.cash_outflow')); ?></th>
                        <th class="text-end"><?php echo e(trans('messages.net_cash_flow')); ?></th>
                    </tr>
                </thead>
                <tbody>
                    <?php $__empty_1 = true; $__currentLoopData = $cashFlow; $__env->addLoop($__currentLoopData); foreach($__currentLoopData as $flow): $__env->incrementLoopIndices(); $loop = $__env->getLastLoop(); $__empty_1 = false; ?>
                    <tr>
                        <td><?php echo e(\Carbon\Carbon::parse($flow['date'])->format('Y-m-d')); ?></td>
                        <td class="text-end text-success"><?php echo e(format_currency($flow['inflow'])); ?></td>
                        <td class="text-end text-danger"><?php echo e(format_currency($flow['outflow'])); ?></td>
                        <td class="text-end <?php echo e($flow['net'] >= 0 ? 'text-success' : 'text-danger'); ?>">
                            <?php echo e(format_currency($flow['net'])); ?>

                        </td>
                    </tr>
                    <?php endforeach; $__env->popLoop(); $loop = $__env->getLastLoop(); if ($__empty_1): ?>
                    <tr>
                        <td colspan="4" class="text-center"><?php echo e(trans('messages.no_data')); ?></td>
                    </tr>
                    <?php endif; ?>
                </tbody>
            </table>
        </div>
    </div>
</div>

<?php echo $__env->make('reports.partials.print-styles', ['reportTitle' => trans('messages.cash_flow_report')], \Illuminate\Support\Arr::except(get_defined_vars(), ['__data', '__path']))->render(); ?>
<?php $__env->stopSection(); ?>


<?php echo $__env->make('layouts.master', \Illuminate\Support\Arr::except(get_defined_vars(), ['__data', '__path']))->render(); ?><?php /**PATH C:\xampp\htdocs\GestionStock\resources\views/reports/cash-flow.blade.php ENDPATH**/ ?>