<?php
    $storeName = \App\Models\Setting::get('store_name', 'Gestock Pro');
    $storeLogo = \App\Models\Setting::get('store_logo');
    $currency = currency_symbol();
    $locale = app()->getLocale();
    $isRTL = $locale === 'ar';
    $dir = $isRTL ? 'rtl' : 'ltr';
    $dateFrom = $request->filled('date_from') ? $request->date_from : now()->startOfMonth()->format('Y-m-d');
    $dateTo = $request->filled('date_to') ? $request->date_to : now()->endOfMonth()->format('Y-m-d');
    $statusFilter = $request->filled('status') ? $request->status : trans('messages.all_status');
?>
<!DOCTYPE html>
<html lang="<?php echo e($locale); ?>" dir="<?php echo e($dir); ?>">
<head>
    <meta charset="UTF-8">
    <meta name="viewport" content="width=device-width, initial-scale=1.0">
    <title><?php echo e(trans('messages.sales_report_title')); ?></title>
    <link rel="stylesheet" href="<?php echo e(asset('lib/fonts/google-fonts.css')); ?>">
    <style>
        @charset "UTF-8";
        
        * {
            margin: 0;
            padding: 0;
            box-sizing: border-box;
        }
        
        body {
            font-family: <?php echo e($isRTL ? "'Cairo', 'DejaVu Sans', sans-serif" : "'Cabin', 'DejaVu Sans', sans-serif"); ?>;
            direction: <?php echo e($dir); ?>;
            font-size: 14px;
            color: #333;
            padding: 20px;
            background-color: #fff;
            unicode-bidi: embed;
        }
        
        <?php if($isRTL): ?>
        * {
            font-family: 'Cairo', 'DejaVu Sans', sans-serif !important;
        }
        <?php else: ?>
        * {
            font-family: 'Cabin', 'DejaVu Sans', sans-serif !important;
        }
        <?php endif; ?>
        
        .header {
            display: flex;
            justify-content: space-between;
            align-items: center;
            margin-bottom: 30px;
            border-bottom: 2px solid #333;
            padding-bottom: 20px;
        }
        
        .logo-container {
            <?php echo e($isRTL ? 'text-align: right;' : 'text-align: left;'); ?>

        }
        
        .logo-container img {
            max-height: 80px;
            max-width: 200px;
        }
        
        .report-info {
            <?php echo e($isRTL ? 'text-align: left;' : 'text-align: right;'); ?>

        }
        
        .report-info h2 {
            margin-bottom: 10px;
            color: #333;
            font-size: 24px;
        }
        
        .report-info p {
            margin: 5px 0;
            font-size: 14px;
            color: #666;
        }
        
        .summary {
            display: flex;
            justify-content: space-around;
            margin-bottom: 30px;
            padding: 20px;
            background-color: #f8f9fa;
            border-radius: 5px;
        }
        
        .summary-item {
            text-align: center;
        }
        
        .summary-item h4 {
            font-size: 14px;
            color: #666;
            margin-bottom: 10px;
        }
        
        .summary-item .value {
            font-size: 20px;
            font-weight: bold;
            color: #333;
        }
        
        table {
            width: 100%;
            border-collapse: collapse;
            margin-bottom: 30px;
        }
        
        thead {
            background-color: #343a40;
            color: white;
        }
        
        th, td {
            padding: 12px;
            text-align: <?php echo e($isRTL ? 'right' : 'left'); ?>;
            border: 1px solid #dee2e6;
        }
        
        th {
            font-weight: bold;
            font-size: 14px;
        }
        
        td {
            font-size: 13px;
        }
        
        tbody tr:nth-child(even) {
            background-color: #f8f9fa;
        }
        
        tbody tr.returned {
            background-color: #f8d7da;
        }
        
        .text-right {
            text-align: <?php echo e($isRTL ? 'left' : 'right'); ?>;
        }
        
        .text-center {
            text-align: center;
        }
        
        .badge {
            padding: 5px 10px;
            border-radius: 4px;
            font-size: 12px;
            font-weight: bold;
        }
        
        .badge-success {
            background-color: #28a745;
            color: white;
        }
        
        .badge-warning {
            background-color: #ffc107;
            color: #333;
        }
        
        .badge-danger {
            background-color: #dc3545;
            color: white;
        }
        
        .badge-info {
            background-color: #17a2b8;
            color: white;
        }
        
        .badge-secondary {
            background-color: #6c757d;
            color: white;
        }
        
        .print-actions {
            margin-bottom: 20px;
            text-align: center;
        }
        
        .print-actions button {
            padding: 10px 20px;
            font-size: 16px;
            background-color: #0d6efd;
            color: white;
            border: none;
            border-radius: 5px;
            cursor: pointer;
            margin: 0 10px;
        }
        
        .print-actions button:hover {
            background-color: #0b5ed7;
        }
        
        @media print {
            .print-actions {
                display: none;
            }
            
            @page {
                size: landscape;
                margin: 10mm;
            }
            
            body {
                padding: 0;
            }
        }
    </style>
</head>
<body>
    <div class="print-actions">
        <button onclick="window.print()" class="btn btn-primary">
            <i class="bi bi-printer"></i> <?php echo e(trans('messages.print')); ?>

        </button>
        <button onclick="window.close()" class="btn btn-secondary" style="margin-<?php echo e($isRTL ? 'right' : 'left'); ?>: 10px;">
            <i class="bi bi-x-circle"></i> <?php echo e(trans('messages.close')); ?>

        </button>
    </div>

    <div class="header">
        <div class="logo-container">
            <?php if($storeLogo): ?>
                <img src="<?php echo e(storage_url( $storeLogo)); ?>" alt="<?php echo e($storeName); ?>">
            <?php else: ?>
                <h2><?php echo e($storeName); ?></h2>
            <?php endif; ?>
        </div>
        <div class="report-info">
            <h2><?php echo e(trans('messages.sales_report_title')); ?></h2>
            <p><?php echo e(trans('messages.from_date')); ?>: <?php echo e($dateFrom); ?></p>
            <p><?php echo e(trans('messages.to_date')); ?>: <?php echo e($dateTo); ?></p>
            <p><?php echo e(trans('messages.status')); ?>: <?php echo e(is_string($statusFilter) ? $statusFilter : trans('messages.' . $statusFilter)); ?></p>
            <p><?php echo e(trans('messages.date')); ?>: <?php echo e(now()->format('Y-m-d H:i')); ?></p>
        </div>
    </div>

    <div class="summary">
        <div class="summary-item">
            <h4><?php echo e(trans('messages.total_sales')); ?></h4>
            <div class="value"><?php echo e(format_currency($totalSales)); ?></div>
        </div>
        <div class="summary-item">
            <h4><?php echo e(trans('messages.total')); ?> <?php echo e(trans('messages.paid')); ?></h4>
            <div class="value"><?php echo e(format_currency($totalPaid)); ?></div>
        </div>
        <div class="summary-item">
            <h4><?php echo e(trans('messages.total')); ?> <?php echo e(trans('messages.due')); ?></h4>
            <div class="value"><?php echo e(format_currency($totalDue)); ?></div>
        </div>
        <div class="summary-item">
            <h4><?php echo e(trans('messages.total_profit')); ?></h4>
            <div class="value"><?php echo e(format_currency($totalProfit)); ?></div>
        </div>
    </div>

    <table>
        <thead>
            <tr>
                <th><?php echo e(trans('messages.invoice_number')); ?></th>
                <th><?php echo e(trans('messages.date')); ?></th>
                <th><?php echo e(trans('messages.customer')); ?></th>
                <th class="text-right"><?php echo e(trans('messages.total')); ?></th>
                <th class="text-right"><?php echo e(trans('messages.paid')); ?></th>
                <th class="text-right"><?php echo e(trans('messages.due')); ?></th>
                <th class="text-right"><?php echo e(trans('messages.profit')); ?></th>
                <th><?php echo e(trans('messages.status')); ?></th>
            </tr>
        </thead>
        <tbody>
            <?php $__empty_1 = true; $__currentLoopData = $invoices; $__env->addLoop($__currentLoopData); foreach($__currentLoopData as $invoice): $__env->incrementLoopIndices(); $loop = $__env->getLastLoop(); $__empty_1 = false; ?>
            <tr class="<?php echo e($invoice->status === 'returned' ? 'returned' : ''); ?>">
                <td><?php echo e($invoice->invoice_number); ?></td>
                <td><?php echo e($invoice->created_at->format('Y-m-d')); ?></td>
                <td><?php echo e($invoice->customer?->name ?? $invoice->customer_name); ?></td>
                <td class="text-right"><?php echo e(format_currency($invoice->total)); ?></td>
                <td class="text-right"><?php echo e(format_currency($invoice->paid_amount)); ?></td>
                <td class="text-right"><?php echo e(format_currency($invoice->due_amount)); ?></td>
                <td class="text-right"><?php echo e(format_currency($invoice->profit)); ?></td>
                <td>
                    <?php
                        $badgeClass = match($invoice->status) {
                            'paid' => 'success',
                            'partially_paid' => 'warning',
                            'draft' => 'secondary',
                            'returned' => 'danger',
                            default => 'info'
                        };
                    ?>
                    <span class="badge badge-<?php echo e($badgeClass); ?>"><?php echo e(trans('messages.' . $invoice->status)); ?></span>
                </td>
            </tr>
            <?php endforeach; $__env->popLoop(); $loop = $__env->getLastLoop(); if ($__empty_1): ?>
            <tr>
                <td colspan="8" class="text-center"><?php echo e(trans('messages.no_invoices_found')); ?></td>
            </tr>
            <?php endif; ?>
        </tbody>
    </table>
</body>
</html>

<?php /**PATH C:\xampp\htdocs\GestionStock\resources\views/reports/sales/print.blade.php ENDPATH**/ ?>