

<?php $__env->startSection('title', trans('messages.sales_report_title')); ?>

<?php $__env->startSection('content'); ?>
<div class="page-header">
    <h2><?php echo e(trans('messages.sales_report_title')); ?></h2>
    <div>
        <button onclick="window.print()" class="btn btn-primary">
            <i class="bi bi-printer"></i> <?php echo e(trans('messages.print_report')); ?>

        </button>
        <a href="<?php echo e(route('reports.sales.export', request()->all())); ?>" class="btn btn-success"><i class="bi bi-file-earmark-excel"></i> <?php echo e(trans('messages.export_excel')); ?></a>
        <a href="<?php echo e(route('reports.sales.export_pdf', request()->all())); ?>" target="_blank" class="btn btn-danger"><i class="bi bi-file-earmark-pdf"></i> <?php echo e(trans('messages.export_pdf')); ?></a>
        <a href="<?php echo e(route('reports.index')); ?>" class="btn btn-secondary">
            <i class="bi bi-arrow-left"></i> <?php echo e(trans('messages.back')); ?>

        </a>
    </div>
</div>

<div class="card mb-3">
    <div class="card-body">
        <form method="GET" action="<?php echo e(route('reports.sales')); ?>">
            <div class="row g-3">
                <div class="col-md-3">
                    <label for="date_from" class="form-label"><?php echo e(trans('messages.from_date')); ?></label>
                    <input type="date" name="date_from" class="form-control" value="<?php echo e(request('date_from', now()->startOfMonth()->format('Y-m-d'))); ?>">
                </div>
                <div class="col-md-3">
                    <label for="date_to" class="form-label"><?php echo e(trans('messages.to_date')); ?></label>
                    <input type="date" name="date_to" class="form-control" value="<?php echo e(request('date_to', now()->endOfMonth()->format('Y-m-d'))); ?>">
                </div>
                <div class="col-md-3">
                    <label for="status" class="form-label"><?php echo e(trans('messages.status')); ?></label>
                    <select name="status" class="form-select">
                        <option value=""><?php echo e(trans('messages.all_status')); ?></option>
                        <option value="draft" <?php echo e(request('status') == 'draft' ? 'selected' : ''); ?>><?php echo e(trans('messages.draft')); ?></option>
                        <option value="final" <?php echo e(request('status') == 'final' ? 'selected' : ''); ?>><?php echo e(trans('messages.final')); ?></option>
                        <option value="paid" <?php echo e(request('status') == 'paid' ? 'selected' : ''); ?>><?php echo e(trans('messages.paid')); ?></option>
                        <option value="partially_paid" <?php echo e(request('status') == 'partially_paid' ? 'selected' : ''); ?>><?php echo e(trans('messages.partially_paid')); ?></option>
                        <option value="returned" <?php echo e(request('status') == 'returned' ? 'selected' : ''); ?>><?php echo e(trans('messages.returned')); ?></option>
                    </select>
                </div>
                <div class="col-md-3">
                    <label class="form-label">&nbsp;</label>
                    <button type="submit" class="btn btn-secondary w-100 d-block"><?php echo e(trans('messages.filter')); ?></button>
                </div>
            </div>
        </form>
    </div>
</div>

<div class="row g-3 mb-4">
    <div class="col-md-3">
        <div class="card text-white bg-primary">
            <div class="card-body">
                <h5><?php echo e(trans('messages.total_sales')); ?></h5>
                <h3><?php echo e(format_currency($totalSales)); ?></h3>
            </div>
        </div>
    </div>
    <div class="col-md-3">
        <div class="card text-white bg-success">
            <div class="card-body">
                <h5><?php echo e(trans('messages.paid_amount')); ?></h5>
                <h3><?php echo e(format_currency($totalPaid)); ?></h3>
            </div>
        </div>
    </div>
    <div class="col-md-3">
        <div class="card text-white bg-warning">
            <div class="card-body">
                <h5><?php echo e(trans('messages.due_amount')); ?></h5>
                <h3><?php echo e(format_currency($totalDue)); ?></h3>
            </div>
        </div>
    </div>
    <div class="col-md-3">
        <div class="card text-white bg-info">
            <div class="card-body">
                <h5><?php echo e(trans('messages.total_profit')); ?></h5>
                <h3><?php echo e(format_currency($totalProfit)); ?></h3>
            </div>
        </div>
    </div>
</div>

<div class="card">
    <div class="card-body">
        <div class="table-responsive">
            <table class="table">
                <thead>
                    <tr>
                        <th><?php echo e(trans('messages.invoice_number')); ?></th>
                        <th><?php echo e(trans('messages.date')); ?></th>
                        <th><?php echo e(trans('messages.customer')); ?></th>
                        <th class="text-end"><?php echo e(trans('messages.total')); ?></th>
                        <th class="text-end"><?php echo e(trans('messages.paid_amount')); ?></th>
                        <th class="text-end"><?php echo e(trans('messages.due_amount')); ?></th>
                        <th class="text-end"><?php echo e(trans('messages.profit')); ?></th>
                        <th><?php echo e(trans('messages.status')); ?></th>
                    </tr>
                </thead>
                <tbody>
                    <?php $__empty_1 = true; $__currentLoopData = $invoices; $__env->addLoop($__currentLoopData); foreach($__currentLoopData as $invoice): $__env->incrementLoopIndices(); $loop = $__env->getLastLoop(); $__empty_1 = false; ?>
                    <tr class="<?php echo e($invoice->status === 'returned' ? 'table-danger' : ''); ?>">
                        <td><a href="<?php echo e(route('invoices.show', $invoice)); ?>"><?php echo e($invoice->invoice_number); ?></a></td>
                        <td><?php echo e($invoice->created_at->format('Y-m-d')); ?></td>
                        <td><?php echo e($invoice->customer?->name ?? $invoice->customer_name); ?></td>
                        <td class="text-end"><?php echo e(format_currency($invoice->total)); ?></td>
                        <td class="text-end"><?php echo e(format_currency($invoice->paid_amount)); ?></td>
                        <td class="text-end"><?php echo e(format_currency($invoice->due_amount)); ?></td>
                        <td>
                            <?php
                                $profit = $invoice->items->sum(function ($item) {
                                    $revenue = $item->total;
                                    $cost = $item->quantity * ($item->product->purchase_price ?? 0);
                                    return $revenue - $cost;
                                });
                            ?>
                            <strong><?php echo e(format_currency($profit)); ?></strong>
                        </td>
                        <td>
                            <?php
                                $badgeClass = match($invoice->status) {
                                    'paid' => 'success',
                                    'partially_paid' => 'warning',
                                    'draft' => 'secondary',
                                    'returned' => 'danger',
                                    default => 'info'
                                };
                            ?>
                            <span class="badge bg-<?php echo e($badgeClass); ?>"><?php echo e(trans('messages.' . $invoice->status)); ?></span>
                        </td>
                    </tr>
                    <?php endforeach; $__env->popLoop(); $loop = $__env->getLastLoop(); if ($__empty_1): ?>
                    <tr>
                        <td colspan="8" class="text-center"><?php echo e(trans('messages.no_invoices_found')); ?></td>
                    </tr>
                    <?php endif; ?>
                </tbody>
            </table>
        </div>
        <?php if(method_exists($invoices, 'links')): ?>
            <div class="card-footer">
                <?php echo e($invoices->links()); ?>

            </div>
        <?php endif; ?>
    </div>
</div>

<?php echo $__env->make('reports.partials.print-styles', ['reportTitle' => trans('messages.sales_report_title')], \Illuminate\Support\Arr::except(get_defined_vars(), ['__data', '__path']))->render(); ?>
<?php $__env->stopSection(); ?>

<?php echo $__env->make('layouts.master', \Illuminate\Support\Arr::except(get_defined_vars(), ['__data', '__path']))->render(); ?><?php /**PATH C:\xampp\htdocs\GestionStock\resources\views/reports/sales.blade.php ENDPATH**/ ?>