

<?php $__env->startSection('title', trans('messages.invoices')); ?>

<?php $__env->startSection('content'); ?>
<?php
    $sort = request()->get('sort', 'created_at');
    $direction = request()->get('direction', 'desc');
?>
<div class="page-header">
    <h2><?php echo e(trans('messages.invoices')); ?></h2>
    <div class="d-flex gap-2">
        <?php if (app(\Illuminate\Contracts\Auth\Access\Gate::class)->check('invoices.create')): ?>
            <a href="<?php echo e(route('invoices.create')); ?>" class="btn btn-primary">
                <i class="bi bi-receipt"></i> <?php echo e(trans('messages.create_invoice')); ?>

            </a>
        <?php endif; ?>
        <?php if (app(\Illuminate\Contracts\Auth\Access\Gate::class)->check('invoices.export')): ?>
            <a href="<?php echo e(route('invoices.export', request()->query())); ?>" class="btn btn-success"><i class="bi bi-file-earmark-excel"></i> <?php echo e(trans('messages.export_excel')); ?></a>
        <?php endif; ?>
        <?php if (app(\Illuminate\Contracts\Auth\Access\Gate::class)->check('invoices.import')): ?>
            <a href="<?php echo e(route('invoices.import')); ?>" class="btn btn-info"><i class="bi bi-upload"></i> <?php echo e(trans('messages.import_invoices')); ?></a>
        <?php endif; ?>
    </div>
</div>

<div class="card">
    <div class="card-body">
        <form method="GET" action="<?php echo e(route('invoices.index')); ?>" class="mb-3">
            <div class="row g-3">
                <div class="col-md-3">
                    <input type="text" name="search" class="form-control" placeholder="<?php echo e(trans('messages.search')); ?>..." value="<?php echo e(request('search')); ?>">
                </div>
                <div class="col-md-2">
                    <select name="status" class="form-select">
                        <option value=""><?php echo e(trans('messages.all_status')); ?></option>
                        <option value="draft" <?php echo e(request('status') == 'draft' ? 'selected' : ''); ?>><?php echo e(trans('messages.draft')); ?></option>
                        <option value="final" <?php echo e(request('status') == 'final' ? 'selected' : ''); ?>><?php echo e(trans('messages.final')); ?></option>
                        <option value="paid" <?php echo e(request('status') == 'paid' ? 'selected' : ''); ?>><?php echo e(trans('messages.paid')); ?></option>
                        <option value="partially_paid" <?php echo e(request('status') == 'partially_paid' ? 'selected' : ''); ?>><?php echo e(trans('messages.partially_paid')); ?></option>
                        <option value="returned" <?php echo e(request('status') == 'returned' ? 'selected' : ''); ?>><?php echo e(trans('messages.returned')); ?></option>
                    </select>
                </div>
                <div class="col-md-2">
                    <input type="date" name="date_from" class="form-control" value="<?php echo e(request('date_from')); ?>" placeholder="<?php echo e(trans('messages.from_date')); ?>">
                </div>
                <div class="col-md-2">
                    <input type="date" name="date_to" class="form-control" value="<?php echo e(request('date_to')); ?>" placeholder="<?php echo e(trans('messages.to_date')); ?>">
                </div>
                <div class="col-md-3">
                    <button type="submit" class="btn btn-secondary w-100"><?php echo e(trans('messages.filter')); ?></button>
                </div>
            </div>
        </form>

        <?php if (app(\Illuminate\Contracts\Auth\Access\Gate::class)->check('invoices.bulk_delete')): ?>
        <div class="mb-3">
            <button type="button" id="delete-selected-btn" class="btn btn-danger" disabled data-bs-toggle="modal" data-bs-target="#bulkDeleteModal">
                <i class="bi bi-trash"></i> <?php echo e(trans('messages.delete_selected')); ?>

            </button>
        </div>
        <?php endif; ?>

        <form id="bulk-delete-form" method="POST" action="<?php echo e(route('invoices.bulk_delete')); ?>">
            <?php echo csrf_field(); ?>
            <div class="table-responsive">
                <table class="table table-hover">
                    <thead>
                        <tr>
                            <?php if (app(\Illuminate\Contracts\Auth\Access\Gate::class)->check('invoices.bulk_delete')): ?>
                            <th style="width: 40px;">
                                <input type="checkbox" id="select-all" title="<?php echo e(trans('messages.select_all')); ?>">
                            </th>
                            <?php endif; ?>
                            <th>
                            <a href="<?php echo e(request()->fullUrlWithQuery(['sort' => 'invoice_number', 'direction' => ($sort === 'invoice_number' && $direction === 'asc') ? 'desc' : 'asc'])); ?>" class="text-decoration-none text-dark">
                                <?php echo e(trans('messages.invoice_number')); ?>

                                <?php if($sort === 'invoice_number'): ?>
                                    <i class="bi bi-arrow-<?php echo e($direction === 'asc' ? 'up' : 'down'); ?>"></i>
                                <?php else: ?>
                                    <i class="bi bi-arrow-down-up text-muted"></i>
                                <?php endif; ?>
                            </a>
                        </th>
                        <th><?php echo e(trans('messages.customer')); ?></th>
                        <th>
                            <a href="<?php echo e(request()->fullUrlWithQuery(['sort' => 'created_at', 'direction' => ($sort === 'created_at' && $direction === 'asc') ? 'desc' : 'asc'])); ?>" class="text-decoration-none text-dark">
                                <?php echo e(trans('messages.date')); ?>

                                <?php if($sort === 'created_at'): ?>
                                    <i class="bi bi-arrow-<?php echo e($direction === 'asc' ? 'up' : 'down'); ?>"></i>
                                <?php else: ?>
                                    <i class="bi bi-arrow-down-up text-muted"></i>
                                <?php endif; ?>
                            </a>
                        </th>
                        <th>
                            <a href="<?php echo e(request()->fullUrlWithQuery(['sort' => 'total', 'direction' => ($sort === 'total' && $direction === 'asc') ? 'desc' : 'asc'])); ?>" class="text-decoration-none text-dark">
                                <?php echo e(trans('messages.total')); ?>

                                <?php if($sort === 'total'): ?>
                                    <i class="bi bi-arrow-<?php echo e($direction === 'asc' ? 'up' : 'down'); ?>"></i>
                                <?php else: ?>
                                    <i class="bi bi-arrow-down-up text-muted"></i>
                                <?php endif; ?>
                            </a>
                        </th>
                        <th>
                            <a href="<?php echo e(request()->fullUrlWithQuery(['sort' => 'paid_amount', 'direction' => ($sort === 'paid_amount' && $direction === 'asc') ? 'desc' : 'asc'])); ?>" class="text-decoration-none text-dark">
                                <?php echo e(trans('messages.paid')); ?>

                                <?php if($sort === 'paid_amount'): ?>
                                    <i class="bi bi-arrow-<?php echo e($direction === 'asc' ? 'up' : 'down'); ?>"></i>
                                <?php else: ?>
                                    <i class="bi bi-arrow-down-up text-muted"></i>
                                <?php endif; ?>
                            </a>
                        </th>
                        <th>
                            <a href="<?php echo e(request()->fullUrlWithQuery(['sort' => 'due_amount', 'direction' => ($sort === 'due_amount' && $direction === 'asc') ? 'desc' : 'asc'])); ?>" class="text-decoration-none text-dark">
                                <?php echo e(trans('messages.due')); ?>

                                <?php if($sort === 'due_amount'): ?>
                                    <i class="bi bi-arrow-<?php echo e($direction === 'asc' ? 'up' : 'down'); ?>"></i>
                                <?php else: ?>
                                    <i class="bi bi-arrow-down-up text-muted"></i>
                                <?php endif; ?>
                            </a>
                        </th>
                        <th>
                            <a href="<?php echo e(request()->fullUrlWithQuery(['sort' => 'status', 'direction' => ($sort === 'status' && $direction === 'asc') ? 'desc' : 'asc'])); ?>" class="text-decoration-none text-dark">
                                <?php echo e(trans('messages.status')); ?>

                                <?php if($sort === 'status'): ?>
                                    <i class="bi bi-arrow-<?php echo e($direction === 'asc' ? 'up' : 'down'); ?>"></i>
                                <?php else: ?>
                                    <i class="bi bi-arrow-down-up text-muted"></i>
                                <?php endif; ?>
                            </a>
                        </th>
                        <th><?php echo e(trans('messages.actions')); ?></th>
                    </tr>
                </thead>
                <tbody>
                    <?php $__empty_1 = true; $__currentLoopData = $invoices; $__env->addLoop($__currentLoopData); foreach($__currentLoopData as $invoice): $__env->incrementLoopIndices(); $loop = $__env->getLastLoop(); $__empty_1 = false; ?>
                    <tr>
                        <?php if (app(\Illuminate\Contracts\Auth\Access\Gate::class)->check('invoices.bulk_delete')): ?>
                        <td>
                            <input type="checkbox" class="item-checkbox" value="<?php echo e($invoice->id); ?>">
                        </td>
                        <?php endif; ?>
                        <td><a href="<?php echo e(route('invoices.show', $invoice)); ?>"><?php echo e($invoice->invoice_number); ?></a></td>
                        <td><?php echo e($invoice->customer?->name ?? $invoice->customer_name); ?></td>
                        <td><?php echo e($invoice->created_at->format('Y-m-d')); ?></td>
                        <td><?php echo e(format_currency($invoice->total)); ?></td>
                        <td><?php echo e(format_currency($invoice->paid_amount)); ?></td>
                        <td><span class="badge bg-<?php echo e($invoice->due_amount > 0 ? 'warning' : 'success'); ?>"><?php echo e(format_currency($invoice->due_amount)); ?></span></td>
                        <td>
                            <?php
                                $badgeClass = match($invoice->status) {
                                    'paid' => 'success',
                                    'partially_paid' => 'warning',
                                    'draft' => 'secondary',
                                    'returned' => 'danger',
                                    default => 'info'
                                };
                            ?>
                            <span class="badge bg-<?php echo e($badgeClass); ?>"><?php echo e(trans('messages.' . $invoice->status)); ?></span>
                        </td>
                        <td>
                            <?php if (app(\Illuminate\Contracts\Auth\Access\Gate::class)->check('invoices.view')): ?>
                                <a href="<?php echo e(route('invoices.show', $invoice)); ?>" class="btn btn-sm btn-info" title="<?php echo e(trans('messages.view') ?? 'View'); ?>"><i class="bi bi-eye"></i></a>
                            <?php endif; ?>
                            <?php if (app(\Illuminate\Contracts\Auth\Access\Gate::class)->check('invoices.pdf')): ?>
                                <a href="<?php echo e(route('invoices.pdf', $invoice)); ?>" class="btn btn-sm btn-secondary" title="<?php echo e(trans('messages.download_pdf')); ?>" target="_blank"><i class="bi bi-file-pdf"></i></a>
                            <?php endif; ?>
                        </td>
                    </tr>
                    <?php endforeach; $__env->popLoop(); $loop = $__env->getLastLoop(); if ($__empty_1): ?>
                    <tr>
                        <td colspan="<?php echo e(auth()->user()->can('invoices.bulk_delete') ? '9' : '8'); ?>" class="text-center"><?php echo e(trans('messages.no_invoices_found')); ?></td>
                    </tr>
                    <?php endif; ?>
                </tbody>
            </table>
        </div>
        </form>

        <?php echo e($invoices->links()); ?>

    </div>
</div>

<?php echo $__env->make('partials.bulk-delete-modal', \Illuminate\Support\Arr::except(get_defined_vars(), ['__data', '__path']))->render(); ?>
<?php $__env->stopSection(); ?>

<?php echo $__env->make('layouts.master', \Illuminate\Support\Arr::except(get_defined_vars(), ['__data', '__path']))->render(); ?><?php /**PATH C:\xampp\htdocs\GestionStock\resources\views/invoices/index.blade.php ENDPATH**/ ?>