

<?php $__env->startSection('title', trans('messages.stock_takes')); ?>

<?php $__env->startSection('content'); ?>
<div class="page-header">
    <h2><?php echo e(trans('messages.stock_takes')); ?></h2>
    <div>
        <a href="<?php echo e(route('stock-takes.create')); ?>" class="btn btn-primary">
            <i class="bi bi-plus-circle"></i> <?php echo e(trans('messages.create_stock_take')); ?>

        </a>
    </div>
</div>

<div class="card">
    <div class="card-body">
        <form method="GET" action="<?php echo e(route('stock-takes.index')); ?>" class="mb-3">
            <div class="row g-3">
                <div class="col-md-4">
                    <input type="text" name="search" class="form-control" placeholder="<?php echo e(trans('messages.search')); ?>..." value="<?php echo e(request('search')); ?>">
                </div>
                <div class="col-md-3">
                    <select name="status" class="form-select">
                        <option value=""><?php echo e(trans('messages.all_statuses')); ?></option>
                        <option value="draft" <?php echo e(request('status') == 'draft' ? 'selected' : ''); ?>><?php echo e(trans('messages.draft')); ?></option>
                        <option value="in_progress" <?php echo e(request('status') == 'in_progress' ? 'selected' : ''); ?>><?php echo e(trans('messages.in_progress')); ?></option>
                        <option value="completed" <?php echo e(request('status') == 'completed' ? 'selected' : ''); ?>><?php echo e(trans('messages.completed')); ?></option>
                    </select>
                </div>
                <div class="col-md-3">
                    <select name="type" class="form-select">
                        <option value=""><?php echo e(trans('messages.all_types')); ?></option>
                        <option value="full" <?php echo e(request('type') == 'full' ? 'selected' : ''); ?>><?php echo e(trans('messages.full')); ?></option>
                        <option value="partial" <?php echo e(request('type') == 'partial' ? 'selected' : ''); ?>><?php echo e(trans('messages.partial')); ?></option>
                        <option value="scheduled" <?php echo e(request('type') == 'scheduled' ? 'selected' : ''); ?>><?php echo e(trans('messages.scheduled')); ?></option>
                    </select>
                </div>
                <div class="col-md-2">
                    <button type="submit" class="btn btn-secondary w-100"><?php echo e(trans('messages.filter')); ?></button>
                </div>
            </div>
        </form>

        <div class="table-responsive">
            <table class="table table-hover">
                <thead>
                    <tr>
                        <th><?php echo e(trans('messages.reference_number')); ?></th>
                        <th><?php echo e(trans('messages.stock_take_date')); ?></th>
                        <th><?php echo e(trans('messages.type')); ?></th>
                        <th><?php echo e(trans('messages.status')); ?></th>
                        <th><?php echo e(trans('messages.items_count')); ?></th>
                        <th><?php echo e(trans('messages.created_at')); ?></th>
                        <th><?php echo e(trans('messages.actions')); ?></th>
                    </tr>
                </thead>
                <tbody>
                    <?php $__empty_1 = true; $__currentLoopData = $stockTakes; $__env->addLoop($__currentLoopData); foreach($__currentLoopData as $stockTake): $__env->incrementLoopIndices(); $loop = $__env->getLastLoop(); $__empty_1 = false; ?>
                    <tr>
                        <td><a href="<?php echo e(route('stock-takes.show', $stockTake)); ?>"><?php echo e($stockTake->reference_number); ?></a></td>
                        <td><?php echo e($stockTake->stock_take_date->format('Y-m-d')); ?></td>
                        <td>
                            <span class="badge bg-info"><?php echo e(trans('messages.' . $stockTake->type)); ?></span>
                        </td>
                        <td>
                            <?php
                                $badgeClass = match($stockTake->status) {
                                    'draft' => 'secondary',
                                    'in_progress' => 'warning',
                                    'completed' => 'success',
                                    'cancelled' => 'danger',
                                    default => 'secondary'
                                };
                            ?>
                            <span class="badge bg-<?php echo e($badgeClass); ?>"><?php echo e(trans('messages.' . $stockTake->status)); ?></span>
                        </td>
                        <td><?php echo e($stockTake->items->count()); ?></td>
                        <td><?php echo e($stockTake->created_at->format('Y-m-d')); ?></td>
                        <td>
                            <a href="<?php echo e(route('stock-takes.show', $stockTake)); ?>" class="btn btn-sm btn-info"><?php echo e(trans('messages.view')); ?></a>
                            <?php if($stockTake->isDraft()): ?>
                                <a href="<?php echo e(route('stock-takes.edit', $stockTake)); ?>" class="btn btn-sm btn-warning"><?php echo e(trans('messages.edit')); ?></a>
                            <?php endif; ?>
                            <?php if(!$stockTake->isCompleted()): ?>
                                <form action="<?php echo e(route('stock-takes.complete', $stockTake)); ?>" method="POST" class="d-inline">
                                    <?php echo csrf_field(); ?>
                                    <button type="submit" class="btn btn-sm btn-success" onclick="return confirm('<?php echo e(trans('messages.confirm_complete_stock_take')); ?>')">
                                        <?php echo e(trans('messages.complete_stock_take')); ?>

                                    </button>
                                </form>
                            <?php endif; ?>
                        </td>
                    </tr>
                    <?php endforeach; $__env->popLoop(); $loop = $__env->getLastLoop(); if ($__empty_1): ?>
                    <tr>
                        <td colspan="7" class="text-center"><?php echo e(trans('messages.no_stock_takes_found')); ?></td>
                    </tr>
                    <?php endif; ?>
                </tbody>
            </table>
        </div>

        <div class="mt-3">
            <?php echo e($stockTakes->links()); ?>

        </div>
    </div>
</div>
<?php $__env->stopSection(); ?>


<?php echo $__env->make('layouts.master', \Illuminate\Support\Arr::except(get_defined_vars(), ['__data', '__path']))->render(); ?><?php /**PATH C:\xampp\htdocs\GestionStock\resources\views/stock-takes/index.blade.php ENDPATH**/ ?>