

<?php $__env->startSection('title', trans('messages.sales_trends')); ?>

<?php $__env->startSection('content'); ?>
<div class="page-header">
    <h2><?php echo e(trans('messages.sales_trends')); ?></h2>
    <div>
        <button onclick="window.print()" class="btn btn-primary">
            <i class="bi bi-printer"></i> <?php echo e(trans('messages.print_report')); ?>

        </button>
        <a href="<?php echo e(route('analytics.index')); ?>" class="btn btn-secondary">
            <i class="bi bi-arrow-left"></i> <?php echo e(trans('messages.back')); ?>

        </a>
    </div>
</div>

<div class="card mb-3">
    <div class="card-body">
        <form method="GET" action="<?php echo e(route('analytics.sales-trends')); ?>">
            <div class="row g-3">
                <div class="col-md-3">
                    <label for="period" class="form-label"><?php echo e(trans('messages.period')); ?></label>
                    <select name="period" class="form-select">
                        <option value="daily" <?php echo e($period == 'daily' ? 'selected' : ''); ?>><?php echo e(trans('messages.daily')); ?></option>
                        <option value="weekly" <?php echo e($period == 'weekly' ? 'selected' : ''); ?>><?php echo e(trans('messages.weekly')); ?></option>
                        <option value="monthly" <?php echo e($period == 'monthly' ? 'selected' : ''); ?>><?php echo e(trans('messages.monthly')); ?></option>
                        <option value="yearly" <?php echo e($period == 'yearly' ? 'selected' : ''); ?>><?php echo e(trans('messages.yearly')); ?></option>
                    </select>
                </div>
                <div class="col-md-3">
                    <label for="months" class="form-label"><?php echo e(trans('messages.months')); ?></label>
                    <input type="number" name="months" class="form-control" value="<?php echo e($months); ?>" min="1" max="24">
                </div>
                <div class="col-md-3">
                    <label class="form-label">&nbsp;</label>
                    <button type="submit" class="btn btn-primary w-100 d-block"><?php echo e(trans('messages.filter')); ?></button>
                </div>
                <div class="col-md-3">
                    <div class="mt-4">
                        <span class="badge bg-<?php echo e($trendDirection == 'up' ? 'success' : ($trendDirection == 'down' ? 'danger' : 'secondary')); ?>">
                            <?php echo e(trans('messages.trend_direction')); ?>: <?php echo e(trans('messages.trend_' . $trendDirection)); ?>

                        </span>
                    </div>
                </div>
            </div>
        </form>
    </div>
</div>

<div class="row g-3 mb-4">
    <div class="col-md-12">
        <div class="card">
            <div class="card-header">
                <h5 class="mb-0"><?php echo e(trans('messages.sales_trends')); ?></h5>
            </div>
            <div class="card-body">
                <canvas id="salesTrendsChart" height="80"></canvas>
            </div>
        </div>
    </div>
</div>

<div class="row g-3 mb-4">
    <div class="col-md-12">
        <div class="card">
            <div class="card-header">
                <h5 class="mb-0"><?php echo e(trans('messages.profit')); ?></h5>
            </div>
            <div class="card-body">
                <canvas id="profitTrendsChart" height="80"></canvas>
            </div>
        </div>
    </div>
</div>

<?php $__env->startPush('scripts'); ?>
<script>
const salesTrendsCtx = document.getElementById('salesTrendsChart').getContext('2d');
const salesTrendsChart = new Chart(salesTrendsCtx, {
    type: 'line',
    data: {
        labels: <?php echo json_encode($labels, 15, 512) ?>,
        datasets: [{
            label: '<?php echo e(trans('messages.total_sales')); ?>',
            data: <?php echo json_encode($salesData, 15, 512) ?>,
            borderColor: 'rgb(75, 192, 192)',
            backgroundColor: 'rgba(75, 192, 192, 0.2)',
            tension: 0.1
        }, {
            label: '<?php echo e(trans('messages.invoice_count')); ?>',
            data: <?php echo json_encode($countData, 15, 512) ?>,
            borderColor: 'rgb(255, 99, 132)',
            backgroundColor: 'rgba(255, 99, 132, 0.2)',
            tension: 0.1,
            yAxisID: 'y1'
        }]
    },
    options: {
        responsive: true,
        interaction: {
            mode: 'index',
            intersect: false,
        },
        scales: {
            y: {
                type: 'linear',
                display: true,
                position: 'left',
            },
            y1: {
                type: 'linear',
                display: true,
                position: 'right',
                grid: {
                    drawOnChartArea: false,
                },
            },
        }
    }
});

const profitTrendsCtx = document.getElementById('profitTrendsChart').getContext('2d');
const profitTrendsChart = new Chart(profitTrendsCtx, {
    type: 'line',
    data: {
        labels: <?php echo json_encode($labels, 15, 512) ?>,
        datasets: [{
            label: '<?php echo e(trans('messages.profit')); ?>',
            data: <?php echo json_encode($profitData, 15, 512) ?>,
            borderColor: 'rgb(54, 162, 235)',
            backgroundColor: 'rgba(54, 162, 235, 0.2)',
            tension: 0.1,
            fill: true
        }]
    },
    options: {
        responsive: true,
        scales: {
            y: {
                beginAtZero: true
            }
        }
    }
});
</script>
<?php $__env->stopPush(); ?>

<?php $__env->startPush('styles'); ?>
<style>
@media print {
    .page-header, .card.mb-3:first-of-type, .btn {
        display: none !important;
    }
    .card {
        border: none;
        box-shadow: none;
    }
}
</style>
<?php $__env->stopPush(); ?>
<?php $__env->stopSection(); ?>


<?php echo $__env->make('layouts.master', \Illuminate\Support\Arr::except(get_defined_vars(), ['__data', '__path']))->render(); ?><?php /**PATH C:\xampp\htdocs\GestionStock\resources\views/analytics/sales-trends.blade.php ENDPATH**/ ?>