

<?php $__env->startSection('title', 'معلومات الترخيص'); ?>

<?php $__env->startSection('content'); ?>
<div class="row">
    <div class="col-md-8 offset-md-2">
        <div class="card">
            <div class="card-header bg-info text-white">
                <h4><i class="bi bi-info-circle"></i> معلومات الترخيص</h4>
            </div>
            <div class="card-body">
                <?php if($licenseInfo): ?>
                    <table class="table table-bordered">
                        <tr>
                            <th width="200">مفتاح الترخيص</th>
                            <td><?php echo e($licenseInfo['license_key']); ?></td>
                        </tr>
                        <tr>
                            <th>الرقم التسلسلي</th>
                            <td><?php echo e($licenseInfo['serial_number']); ?></td>
                        </tr>
                        <tr>
                            <th>اسم العميل</th>
                            <td><?php echo e($licenseInfo['customer_name'] ?? 'غير محدد'); ?></td>
                        </tr>
                        <tr>
                            <th>البريد الإلكتروني</th>
                            <td><?php echo e($licenseInfo['email'] ?? 'غير محدد'); ?></td>
                        </tr>
                        <tr>
                            <th>تاريخ التفعيل</th>
                            <td><?php echo e($licenseInfo['activated_at']); ?></td>
                        </tr>
                        <tr>
                            <th>تاريخ الانتهاء</th>
                            <td>
                                <?php echo e($licenseInfo['expires_at'] ?? 'دائم'); ?>

                                <?php if($licenseInfo['days_remaining'] !== null): ?>
                                    <span class="badge bg-<?php echo e($licenseInfo['days_remaining'] > 30 ? 'success' : 'warning'); ?>">
                                        <?php echo e($licenseInfo['days_remaining']); ?> يوم متبقي
                                    </span>
                                <?php endif; ?>
                            </td>
                        </tr>
                        <tr>
                            <th>الحالة</th>
                            <td>
                                <span class="badge bg-<?php echo e($licenseInfo['is_valid'] ? 'success' : 'danger'); ?>">
                                    <?php echo e($licenseInfo['is_valid'] ? 'نشط' : 'غير نشط'); ?>

                                </span>
                            </td>
                        </tr>
                        <tr>
                            <th>عدد المستخدمين المسموح</th>
                            <td><?php echo e($licenseInfo['max_users']); ?></td>
                        </tr>
                    </table>
                <?php else: ?>
                    <div class="alert alert-warning">
                        لا يوجد ترخيص مفعّل حالياً.
                    </div>
                <?php endif; ?>

                <div class="mt-3">
                    <a href="<?php echo e(route('license.activate')); ?>" class="btn btn-primary">
                        <i class="bi bi-key"></i> تفعيل ترخيص جديد
                    </a>
                    <a href="<?php echo e(route('dashboard')); ?>" class="btn btn-secondary">
                        <i class="bi bi-arrow-left"></i> العودة
                    </a>
                </div>
            </div>
        </div>
    </div>
</div>
<?php $__env->stopSection(); ?>


<?php echo $__env->make('layouts.master', \Illuminate\Support\Arr::except(get_defined_vars(), ['__data', '__path']))->render(); ?><?php /**PATH C:\xampp\htdocs\GestionStock\resources\views/license/info.blade.php ENDPATH**/ ?>