<?php $__empty_1 = true; $__currentLoopData = $products; $__env->addLoop($__currentLoopData); foreach($__currentLoopData as $product): $__env->incrementLoopIndices(); $loop = $__env->getLastLoop(); $__empty_1 = false; ?>
<?php
    $stockQuantity = \App\Services\StockManager::getStockQuantity($product, $warehouseId);
?>
<div class="col-md-4 col-sm-6">
    <div class="card h-100 product-card <?php echo e($stockQuantity <= 0 ? 'opacity-75' : ''); ?>">
        <?php if(isset($posSettings['show_images']) && $posSettings['show_images']): ?>
            <?php if($product->image): ?>
            <img src="<?php echo e(storage_url($product->image)); ?>" class="card-img-top" alt="<?php echo e($product->name); ?>" style="height: 150px; object-fit: cover;">
            <?php else: ?>
            <div class="card-img-top bg-light d-flex align-items-center justify-content-center" style="height: 150px;">
                <i class="bi bi-basket" style="font-size: 3rem; color: #ccc;"></i>
            </div>
            <?php endif; ?>
        <?php endif; ?>
        <div class="card-body">
            <div class="d-flex justify-content-between align-items-start mb-2">
                <h6 class="card-title mb-0"><?php echo e($isRTL && $product->name_ar ? $product->name_ar : $product->name); ?></h6>
                <button class="btn btn-sm toggle-favorite-btn btn-outline-warning" 
                        data-product-id="<?php echo e($product->id); ?>"
                        title="<?php echo e(trans('messages.add_to_favorites')); ?>">
                    <i class="bi bi-star"></i>
                </button>
            </div>
            <p class="card-text mb-2">
                <strong><?php echo e(format_currency($product->selling_price)); ?></strong>
                <?php if(isset($posSettings['show_stock']) && $posSettings['show_stock']): ?>
                <small class="text-muted d-block">
                    <?php echo e(trans('messages.stock')); ?>: <?php echo e($stockQuantity); ?>

                    <?php if($stockQuantity <= 0): ?>
                        <span class="badge bg-danger ms-2"><?php echo e(trans('messages.out_of_stock')); ?></span>
                    <?php elseif($product->isLowStock($warehouseId)): ?>
                        <span class="badge bg-warning ms-2"><?php echo e(trans('messages.low_stock')); ?></span>
                    <?php endif; ?>
                </small>
                <?php endif; ?>
            </p>
            <div class="input-group mb-2">
                <input type="number" class="form-control product-quantity" 
                       data-product-id="<?php echo e($product->id); ?>" 
                       value="1" min="1" 
                       <?php if(!$allowNegativeStock): ?>
                           max="<?php echo e(max(1, $stockQuantity)); ?>"
                       <?php endif; ?>
                       <?php if(!$allowNegativeStock && $stockQuantity <= 0): ?>
                           disabled
                       <?php endif; ?>>
                <button class="btn btn-primary add-to-cart-btn <?php echo e((!$allowNegativeStock && $stockQuantity <= 0) ? 'disabled' : ''); ?>" 
                        data-product-id="<?php echo e($product->id); ?>"
                        data-product-name="<?php echo e($isRTL && $product->name_ar ? $product->name_ar : $product->name); ?>"
                        <?php if(!$allowNegativeStock && $stockQuantity <= 0): ?>
                            disabled
                        <?php endif; ?>>
                    <i class="bi bi-cart-plus"></i> <?php echo e(trans('messages.add_to_cart')); ?>

                </button>
            </div>
        </div>
    </div>
</div>
<?php endforeach; $__env->popLoop(); $loop = $__env->getLastLoop(); if ($__empty_1): ?>
<div class="col-12">
    <div class="alert alert-info text-center">
        <i class="bi bi-info-circle"></i> <?php echo e(trans('messages.no_products_found')); ?>

    </div>
</div>
<?php endif; ?>

<?php /**PATH C:\xampp\htdocs\GestionStock\resources\views/pos/partials/products-grid.blade.php ENDPATH**/ ?>