<?php
    $currentLocale = app()->getLocale();
    $isRTL = $currentLocale === 'ar';
?>
<div class="sidebar">
    <ul class="nav flex-column">
        <?php if (app(\Illuminate\Contracts\Auth\Access\Gate::class)->check('pos.view')): ?>
        <?php if(\App\Models\Setting::get('pos_enabled', '1') === '1'): ?>
        <li class="nav-item">
            <a class="nav-link <?php echo e(request()->routeIs('pos.*') ? 'active' : ''); ?>" href="<?php echo e(route('pos.index')); ?>">
                <i class="bi bi-cart"></i> <span><?php echo e(trans('messages.pos')); ?></span>
            </a>
        </li>
        <?php endif; ?>
        <?php endif; ?>
        <?php if (app(\Illuminate\Contracts\Auth\Access\Gate::class)->check('dashboard.view')): ?>
        <li class="nav-item">
            <a class="nav-link <?php echo e(request()->routeIs('dashboard') ? 'active' : ''); ?>" href="<?php echo e(route('dashboard')); ?>">
                <i class="bi bi-speedometer2"></i> <span><?php echo e(trans('messages.dashboard')); ?></span>
            </a>
        </li>
        <?php endif; ?>
        <?php if(auth()->user()->can('products.view') || auth()->user()->can('categories.view') || request()->routeIs('stock-alerts.*') || request()->routeIs('stock-takes.*')): ?>
        <li class="nav-item">
            <a class="nav-link" 
               data-bs-toggle="collapse" 
               href="#productsMenu" 
               role="button" 
               aria-expanded="<?php echo e((request()->routeIs('products.*') || request()->routeIs('categories.*') || request()->routeIs('stock-alerts.*') || request()->routeIs('stock-takes.*')) ? 'true' : 'false'); ?>" 
               aria-controls="productsMenu">
                <i class="bi bi-box-seam"></i> <span><?php echo e(trans('messages.products_management')); ?></span>
                <i class="bi bi-chevron-<?php echo e($isRTL ? 'left' : 'right'); ?>" style="margin-<?php echo e($isRTL ? 'right' : 'left'); ?>: auto;"></i>
            </a>
            <div class="collapse <?php echo e((request()->routeIs('products.*') || request()->routeIs('categories.*') || request()->routeIs('stock-alerts.*') || request()->routeIs('stock-takes.*') || request()->routeIs('warehouses.*')) ? 'show' : ''); ?>" id="productsMenu">
                <ul class="nav flex-column ms-3">
                    <?php if (app(\Illuminate\Contracts\Auth\Access\Gate::class)->check('products.view')): ?>
                    <li class="nav-item">
                        <a class="nav-link <?php echo e(request()->routeIs('products.*') ? 'active' : ''); ?>" href="<?php echo e(route('products.index')); ?>">
                            <i class="bi bi-box"></i> <span><?php echo e(trans('messages.products')); ?></span>
                        </a>
                    </li>
                    <?php endif; ?>
                    <?php if (app(\Illuminate\Contracts\Auth\Access\Gate::class)->check('categories.view')): ?>
                    <li class="nav-item">
                        <a class="nav-link <?php echo e(request()->routeIs('categories.*') ? 'active' : ''); ?>" href="<?php echo e(route('categories.index')); ?>">
                            <i class="bi bi-tags"></i> <span><?php echo e(trans('messages.categories')); ?></span>
                        </a>
                    </li>
                    <?php endif; ?>
                    <?php if(\App\Models\Setting::get('warehouse_mode', 'single') === 'multiple'): ?>
                    <li class="nav-item">
                        <a class="nav-link <?php echo e(request()->routeIs('warehouses.*') ? 'active' : ''); ?>" href="<?php echo e(route('warehouses.index')); ?>">
                            <i class="bi bi-building"></i> <span><?php echo e(trans('messages.warehouses')); ?></span>
                        </a>
                    </li>
                    <?php endif; ?>
                    <li class="nav-item">
                        <a class="nav-link <?php echo e(request()->routeIs('stock-alerts.*') ? 'active' : ''); ?>" href="<?php echo e(route('stock-alerts.index')); ?>">
                            <i class="bi bi-exclamation-triangle"></i> <span><?php echo e(trans('messages.stock_alerts')); ?></span>
                        </a>
                    </li>
                    <li class="nav-item">
                        <a class="nav-link <?php echo e(request()->routeIs('stock-takes.*') ? 'active' : ''); ?>" href="<?php echo e(route('stock-takes.index')); ?>">
                            <i class="bi bi-clipboard-check"></i> <span><?php echo e(trans('messages.stock_takes')); ?></span>
                        </a>
                    </li>
                </ul>
            </div>
        </li>
        <?php endif; ?>
        <?php if(auth()->user()->can('invoices.view') || auth()->user()->can('purchase-invoices.view') || request()->routeIs('purchase-orders.*')): ?>
        <li class="nav-item">
            <a class="nav-link" 
               data-bs-toggle="collapse" 
               href="#invoicesMenu" 
               role="button" 
               aria-expanded="<?php echo e((request()->routeIs('invoices.*') || request()->routeIs('purchase-invoices.*') || request()->routeIs('quotations.*') || request()->routeIs('purchase-orders.*')) ? 'true' : 'false'); ?>" 
               aria-controls="invoicesMenu">
                <i class="bi bi-receipt-cutoff"></i> <span><?php echo e(trans('messages.invoices')); ?></span>
                <i class="bi bi-chevron-<?php echo e($isRTL ? 'left' : 'right'); ?>" style="margin-<?php echo e($isRTL ? 'right' : 'left'); ?>: auto;"></i>
            </a>
            <div class="collapse <?php echo e((request()->routeIs('invoices.*') || request()->routeIs('purchase-invoices.*') || request()->routeIs('quotations.*') || request()->routeIs('purchase-orders.*')) ? 'show' : ''); ?>" id="invoicesMenu">
                <ul class="nav flex-column ms-3">
                    <?php if (app(\Illuminate\Contracts\Auth\Access\Gate::class)->check('invoices.view')): ?>
                    <li class="nav-item">
                        <a class="nav-link <?php echo e(request()->routeIs('invoices.*') && !request()->routeIs('quotations.*') ? 'active' : ''); ?>" href="<?php echo e(route('invoices.index')); ?>">
                            <i class="bi bi-receipt"></i> <span><?php echo e(trans('messages.sales_invoices')); ?></span>
                        </a>
                    </li>
                    <?php endif; ?>
                    <?php if (app(\Illuminate\Contracts\Auth\Access\Gate::class)->check('purchase-invoices.view')): ?>
                    <li class="nav-item">
                        <a class="nav-link <?php echo e(request()->routeIs('purchase-invoices.*') ? 'active' : ''); ?>" href="<?php echo e(route('purchase-invoices.index')); ?>">
                            <i class="bi bi-cart-plus"></i> <span><?php echo e(trans('messages.purchase_invoices')); ?></span>
                        </a>
                    </li>
                    <?php endif; ?>

                    <?php if (app(\Illuminate\Contracts\Auth\Access\Gate::class)->check('invoices.view')): ?>
                    <li class="nav-item">
                        <a class="nav-link <?php echo e(request()->routeIs('quotations.*') ? 'active' : ''); ?>" href="<?php echo e(route('quotations.index')); ?>">
                            <i class="bi bi-file-earmark-text"></i> <span><?php echo e(trans('messages.quotations')); ?></span>
                        </a>
                    </li>
                    <?php endif; ?>
                    <li class="nav-item">
                        <a class="nav-link <?php echo e(request()->routeIs('purchase-orders.*') ? 'active' : ''); ?>" href="<?php echo e(route('purchase-orders.index')); ?>">
                            <i class="bi bi-cart-plus"></i> <span><?php echo e(trans('messages.purchase_orders')); ?></span>
                        </a>
                    </li>
                    
                </ul>
            </div>
        </li>
        <?php endif; ?>
        <?php if (app(\Illuminate\Contracts\Auth\Access\Gate::class)->check('customers.view')): ?>
        <li class="nav-item">
            <a class="nav-link <?php echo e(request()->routeIs('customers.*') ? 'active' : ''); ?>" href="<?php echo e(route('customers.index')); ?>">
                <i class="bi bi-people"></i> <span><?php echo e(trans('messages.customers')); ?></span>
            </a>
        </li>
        <?php endif; ?>
        <?php if (app(\Illuminate\Contracts\Auth\Access\Gate::class)->check('suppliers.view')): ?>
        <li class="nav-item">
            <a class="nav-link <?php echo e(request()->routeIs('suppliers.*') ? 'active' : ''); ?>" href="<?php echo e(route('suppliers.index')); ?>">
                <i class="bi bi-truck"></i> <span><?php echo e(trans('messages.suppliers')); ?></span>
            </a>
        </li>
        <?php endif; ?>
        <?php if(auth()->user()->can('treasury.view') || auth()->user()->can('cheques.view') || auth()->user()->can('promissory-notes.view') || auth()->user()->can('reports.view') || auth()->user()->can('analytics.view')): ?>
        <li class="nav-item">
            <a class="nav-link" 
               data-bs-toggle="collapse" 
               href="#accountingMenu" 
               role="button" 
               aria-expanded="<?php echo e((request()->routeIs('cheques.*') || request()->routeIs('promissory-notes.*') || request()->routeIs('treasury.*') || request()->routeIs('reports.*') || request()->routeIs('analytics.*')) ? 'true' : 'false'); ?>" 
               aria-controls="accountingMenu">
                <i class="bi bi-calculator"></i> <span><?php echo e(trans('messages.accounting')); ?></span>
                <i class="bi bi-chevron-<?php echo e($isRTL ? 'left' : 'right'); ?>" style="margin-<?php echo e($isRTL ? 'right' : 'left'); ?>: auto;"></i>
            </a>
            <div class="collapse <?php echo e((request()->routeIs('cheques.*') || request()->routeIs('promissory-notes.*') || request()->routeIs('treasury.*') || request()->routeIs('reports.*') || request()->routeIs('analytics.*')) ? 'show' : ''); ?>" id="accountingMenu">
                <ul class="nav flex-column ms-3">
                    <?php if (app(\Illuminate\Contracts\Auth\Access\Gate::class)->check('treasury.view')): ?>
                    <li class="nav-item">
                        <a class="nav-link <?php echo e(request()->routeIs('treasury.*') ? 'active' : ''); ?>" href="<?php echo e(route('treasury.dashboard')); ?>">
                            <i class="bi bi-cash-coin"></i> <span><?php echo e(trans('messages.treasury')); ?></span>
                        </a>
                    </li>
                    <?php endif; ?>
                    <?php if (app(\Illuminate\Contracts\Auth\Access\Gate::class)->check('cheques.view')): ?>
                    <li class="nav-item">
                        <a class="nav-link <?php echo e(request()->routeIs('cheques.*') ? 'active' : ''); ?>" href="<?php echo e(route('cheques.index')); ?>">
                            <i class="bi bi-bank"></i> <span><?php echo e(trans('messages.cheques')); ?></span>
                        </a>
                    </li>
                    <?php endif; ?>
                    <?php if (app(\Illuminate\Contracts\Auth\Access\Gate::class)->check('promissory-notes.view')): ?>
                    <li class="nav-item">
                        <a class="nav-link <?php echo e(request()->routeIs('promissory-notes.*') ? 'active' : ''); ?>" href="<?php echo e(route('promissory-notes.index')); ?>">
                            <i class="bi bi-file-text"></i> <span><?php echo e(trans('messages.promissory_notes')); ?></span>
                        </a>
                    </li>
                    <?php endif; ?>
                    <?php if (app(\Illuminate\Contracts\Auth\Access\Gate::class)->check('reports.view')): ?>
                    <li class="nav-item">
                        <a class="nav-link <?php echo e(request()->routeIs('reports.*') ? 'active' : ''); ?>" href="<?php echo e(route('reports.index')); ?>">
                            <i class="bi bi-graph-up"></i> <span><?php echo e(trans('messages.reports')); ?></span>
                        </a>
                    </li>
                    <?php endif; ?>
                    <?php if (app(\Illuminate\Contracts\Auth\Access\Gate::class)->check('analytics.view')): ?>
                    <li class="nav-item">
                        <a class="nav-link <?php echo e(request()->routeIs('analytics.*') ? 'active' : ''); ?>" href="<?php echo e(route('analytics.index')); ?>">
                            <i class="bi bi-bar-chart-line"></i> <span><?php echo e(trans('messages.analytics')); ?></span>
                        </a>
                    </li>
                    <?php endif; ?>
                </ul>
            </div>
        </li>
        <?php endif; ?>
        <?php if((auth()->user()->can('quality.defects.view') || auth()->user()->can('quality.complaints.view') || auth()->user()->can('quality.reports.view')) && \App\Models\Setting::get('menu_show_quality', '1') === '1'): ?>
        <li class="nav-item">
            <a class="nav-link <?php echo e(request()->routeIs('quality.*') ? 'active' : ''); ?>" 
               data-bs-toggle="collapse" 
               href="#qualityMenu" 
               role="button" 
               aria-expanded="<?php echo e(request()->routeIs('quality.*') ? 'true' : 'false'); ?>" 
               aria-controls="qualityMenu">
                <i class="bi bi-shield-check"></i> <span><?php echo e(trans('messages.quality_management')); ?></span>
                <i class="bi bi-chevron-<?php echo e($isRTL ? 'left' : 'right'); ?>" style="margin-<?php echo e($isRTL ? 'right' : 'left'); ?>: auto;"></i>
            </a>
            <div class="collapse <?php echo e(request()->routeIs('quality.*') ? 'show' : ''); ?>" id="qualityMenu">
                <ul class="nav flex-column ms-3">
                    <?php if (app(\Illuminate\Contracts\Auth\Access\Gate::class)->check('quality.defects.view')): ?>
                    <li class="nav-item">
                        <a class="nav-link <?php echo e(request()->routeIs('quality.defects.*') ? 'active' : ''); ?>" href="<?php echo e(route('quality.defects.index')); ?>">
                            <i class="bi bi-exclamation-triangle"></i> <span><?php echo e(trans('messages.product_defects')); ?></span>
                        </a>
                    </li>
                    <?php endif; ?>
                    <?php if (app(\Illuminate\Contracts\Auth\Access\Gate::class)->check('quality.complaints.view')): ?>
                    <li class="nav-item">
                        <a class="nav-link <?php echo e(request()->routeIs('quality.complaints.*') ? 'active' : ''); ?>" href="<?php echo e(route('quality.complaints.index')); ?>">
                            <i class="bi bi-chat-left-text"></i> <span><?php echo e(trans('messages.quality_complaints')); ?></span>
                        </a>
                    </li>
                    <?php endif; ?>
                    <?php if (app(\Illuminate\Contracts\Auth\Access\Gate::class)->check('quality.reports.view')): ?>
                    <li class="nav-item">
                        <a class="nav-link <?php echo e(request()->routeIs('quality.reports.*') ? 'active' : ''); ?>" href="<?php echo e(route('quality.reports.index')); ?>">
                            <i class="bi bi-file-earmark-bar-graph"></i> <span><?php echo e(trans('messages.quality_reports')); ?></span>
                        </a>
                    </li>
                    <?php endif; ?>
                </ul>
            </div>
        </li>
        <?php endif; ?>
        <?php if(auth()->user()->can('settings.view') || auth()->user()->can('users.view') || auth()->user()->can('backups.view') || auth()->user()->can('permissions.view') || auth()->user()->can('activity-logs.view')): ?>
        <li class="nav-item">
            <a class="nav-link" 
               data-bs-toggle="collapse" 
               href="#systemMenu" 
               role="button" 
               aria-expanded="<?php echo e((request()->routeIs('settings.*') || request()->routeIs('users.*') || request()->routeIs('backups.*') || request()->routeIs('permissions.*') || request()->routeIs('activity-logs.*')) ? 'true' : 'false'); ?>" 
               aria-controls="systemMenu">
                <i class="bi bi-gear-wide-connected"></i> <span><?php echo e(trans('messages.system_management')); ?></span>
                <i class="bi bi-chevron-<?php echo e($isRTL ? 'left' : 'right'); ?>" style="margin-<?php echo e($isRTL ? 'right' : 'left'); ?>: auto;"></i>
            </a>
            <div class="collapse <?php echo e((request()->routeIs('settings.*') || request()->routeIs('users.*') || request()->routeIs('backups.*') || request()->routeIs('permissions.*') || request()->routeIs('activity-logs.*')) ? 'show' : ''); ?>" id="systemMenu">
                <ul class="nav flex-column ms-3">
                    <?php if (app(\Illuminate\Contracts\Auth\Access\Gate::class)->check('settings.view')): ?>
                    <li class="nav-item">
                        <a class="nav-link <?php echo e(request()->routeIs('settings.*') ? 'active' : ''); ?>" href="<?php echo e(route('settings.index')); ?>">
                            <i class="bi bi-gear"></i> <span><?php echo e(trans('messages.settings')); ?></span>
                        </a>
                    </li>
                    <?php endif; ?>
                    <?php if (app(\Illuminate\Contracts\Auth\Access\Gate::class)->check('users.view')): ?>
                    <li class="nav-item">
                        <a class="nav-link <?php echo e(request()->routeIs('users.*') ? 'active' : ''); ?>" href="<?php echo e(route('users.index')); ?>">
                            <i class="bi bi-person-gear"></i> <span><?php echo e(trans('messages.users')); ?></span>
                        </a>
                    </li>
                    <?php endif; ?>
                    <?php if (app(\Illuminate\Contracts\Auth\Access\Gate::class)->check('permissions.view')): ?>
                    <li class="nav-item">
                        <a class="nav-link <?php echo e(request()->routeIs('permissions.*') ? 'active' : ''); ?>" href="<?php echo e(route('permissions.index')); ?>">
                            <i class="bi bi-shield-lock"></i> <span><?php echo e(trans('messages.permissions_management')); ?></span>
                        </a>
                    </li>
                    <?php endif; ?>
                    <?php if (app(\Illuminate\Contracts\Auth\Access\Gate::class)->check('activity-logs.view')): ?>
                    <li class="nav-item">
                        <a class="nav-link <?php echo e(request()->routeIs('activity-logs.*') ? 'active' : ''); ?>" href="<?php echo e(route('activity-logs.index')); ?>">
                            <i class="bi bi-clock-history"></i> <span><?php echo e(trans('messages.activity_logs')); ?></span>
                        </a>
                    </li>
                    <?php endif; ?>
                    <?php if (app(\Illuminate\Contracts\Auth\Access\Gate::class)->check('backups.view')): ?>
                    <li class="nav-item">
                        <a class="nav-link <?php echo e(request()->routeIs('backups.*') ? 'active' : ''); ?>" href="<?php echo e(route('backups.index')); ?>">
                            <i class="bi bi-database"></i> <span><?php echo e(trans('messages.database_backup')); ?></span>
                        </a>
                    </li>
                    <?php endif; ?>
                </ul>
            </div>
        </li>
        <?php endif; ?>
        <?php if (app(\Illuminate\Contracts\Auth\Access\Gate::class)->check('user-guide.view')): ?>
        <li class="nav-item">
            <a class="nav-link <?php echo e(request()->routeIs('user-guide.*') ? 'active' : ''); ?>" href="<?php echo e(route('user-guide.index')); ?>">
                <i class="bi bi-book"></i> <span><?php echo e(trans('messages.user_guide')); ?></span>
            </a>
        </li>
        <?php endif; ?>
    </ul>
</div>
<?php /**PATH C:\xampp\htdocs\GestionStock\resources\views/layouts/partials/sidebar.blade.php ENDPATH**/ ?>