

<?php $__env->startSection('title', trans('messages.purchase_invoices')); ?>

<?php $__env->startSection('content'); ?>
<?php
    $sort = request()->get('sort', 'created_at');
    $direction = request()->get('direction', 'desc');
?>
<div class="page-header">
    <h2><?php echo e(trans('messages.purchase_invoices')); ?></h2>
    <div class="d-flex gap-2">
        <?php if (app(\Illuminate\Contracts\Auth\Access\Gate::class)->check('purchase-invoices.create')): ?>
            <a href="<?php echo e(route('purchase-invoices.create')); ?>" class="btn btn-primary"><i class="bi bi-plus-circle"></i> <?php echo e(trans('messages.add_purchase_invoice')); ?></a>
        <?php endif; ?>
        <?php if (app(\Illuminate\Contracts\Auth\Access\Gate::class)->check('purchase-invoices.export')): ?>
            <a href="<?php echo e(route('purchase-invoices.export', request()->query())); ?>" class="btn btn-success"><i class="bi bi-file-earmark-excel"></i> <?php echo e(trans('messages.export_excel')); ?></a>
        <?php endif; ?>
        <?php if (app(\Illuminate\Contracts\Auth\Access\Gate::class)->check('purchase-invoices.import')): ?>
            <a href="<?php echo e(route('purchase-invoices.import')); ?>" class="btn btn-info"><i class="bi bi-upload"></i> <?php echo e(trans('messages.import_purchase_invoices')); ?></a>
        <?php endif; ?>
    </div>
</div>

<div class="card">
    <div class="card-body">
        <form method="GET" action="<?php echo e(route('purchase-invoices.index')); ?>" class="mb-3">
            <div class="row g-3">
                <div class="col-md-3">
                    <input type="text" name="search" class="form-control" placeholder="<?php echo e(trans('messages.search')); ?>..." value="<?php echo e(request('search')); ?>">
                </div>
                <div class="col-md-2">
                    <select name="status" class="form-select">
                        <option value=""><?php echo e(trans('messages.all_status')); ?></option>
                        <option value="draft" <?php echo e(request('status') == 'draft' ? 'selected' : ''); ?>><?php echo e(trans('messages.draft')); ?></option>
                        <option value="confirmed" <?php echo e(request('status') == 'confirmed' ? 'selected' : ''); ?>><?php echo e(trans('messages.confirmed')); ?></option>
                        <option value="paid" <?php echo e(request('status') == 'paid' ? 'selected' : ''); ?>><?php echo e(trans('messages.paid')); ?></option>
                        <option value="partially_paid" <?php echo e(request('status') == 'partially_paid' ? 'selected' : ''); ?>><?php echo e(trans('messages.partially_paid')); ?></option>
                        <option value="returned" <?php echo e(request('status') == 'returned' ? 'selected' : ''); ?>><?php echo e(trans('messages.returned')); ?></option>
                    </select>
                </div>
                <div class="col-md-2">
                    <select name="supplier_id" class="form-select">
                        <option value=""><?php echo e(trans('messages.all_suppliers') ?? 'All Suppliers'); ?></option>
                        <?php $__currentLoopData = $suppliers; $__env->addLoop($__currentLoopData); foreach($__currentLoopData as $supplier): $__env->incrementLoopIndices(); $loop = $__env->getLastLoop(); ?>
                            <option value="<?php echo e($supplier->id); ?>" <?php echo e(request('supplier_id') == $supplier->id ? 'selected' : ''); ?>><?php echo e($supplier->name); ?></option>
                        <?php endforeach; $__env->popLoop(); $loop = $__env->getLastLoop(); ?>
                    </select>
                </div>
                <div class="col-md-2">
                    <input type="date" name="date_from" class="form-control" value="<?php echo e(request('date_from')); ?>" placeholder="<?php echo e(trans('messages.from_date')); ?>">
                </div>
                <div class="col-md-2">
                    <input type="date" name="date_to" class="form-control" value="<?php echo e(request('date_to')); ?>" placeholder="<?php echo e(trans('messages.to_date')); ?>">
                </div>
                <div class="col-md-1">
                    <button type="submit" class="btn btn-secondary w-100"><?php echo e(trans('messages.filter')); ?></button>
                </div>
            </div>
        </form>

        <?php if(isset($supplierBalance) && $supplierBalance !== null && request('supplier_id')): ?>
            <?php
                $selectedSupplier = \App\Models\Supplier::find(request('supplier_id'));
            ?>
            <?php if($selectedSupplier): ?>
            <div class="alert alert-info mb-3">
                <strong><?php echo e(trans('messages.supplier')); ?>:</strong> <?php echo e($selectedSupplier->name); ?><br>
                <strong><?php echo e(trans('messages.current_balance')); ?>:</strong> 
                <span class="badge <?php echo e($supplierBalance > 0 ? 'text-danger bg-light' : 'text-success bg-light'); ?>">
                    <?php echo e(format_currency($supplierBalance)); ?>

                </span>
            </div>
            <?php endif; ?>
        <?php endif; ?>

        <?php if (app(\Illuminate\Contracts\Auth\Access\Gate::class)->check('purchase-invoices.bulk_delete')): ?>
        <div class="mb-3">
            <button type="button" id="delete-selected-btn" class="btn btn-danger" disabled data-bs-toggle="modal" data-bs-target="#bulkDeleteModal">
                <i class="bi bi-trash"></i> <?php echo e(trans('messages.delete_selected')); ?>

            </button>
        </div>
        <?php endif; ?>

        <form id="bulk-delete-form" method="POST" action="<?php echo e(route('purchase-invoices.bulk_delete')); ?>">
            <?php echo csrf_field(); ?>
            <div class="table-responsive">
                <table class="table table-hover">
                    <thead>
                        <tr>
                            <?php if(auth()->user()->hasAnyRole(['Admin', 'Super Admin'])): ?>
                            <th style="width: 40px;">
                                <input type="checkbox" id="select-all" title="<?php echo e(trans('messages.select_all')); ?>">
                            </th>
                            <?php endif; ?>
                            <th>
                            <a href="<?php echo e(request()->fullUrlWithQuery(['sort' => 'invoice_number', 'direction' => ($sort === 'invoice_number' && $direction === 'asc') ? 'desc' : 'asc'])); ?>" class="text-decoration-none text-dark">
                                <?php echo e(trans('messages.invoice_number')); ?>

                                <?php if($sort === 'invoice_number'): ?>
                                    <i class="bi bi-arrow-<?php echo e($direction === 'asc' ? 'up' : 'down'); ?>"></i>
                                <?php else: ?>
                                    <i class="bi bi-arrow-down-up text-muted"></i>
                                <?php endif; ?>
                            </a>
                        </th>
                        <th><?php echo e(trans('messages.suppliers')); ?></th>
                        <th>
                            <a href="<?php echo e(request()->fullUrlWithQuery(['sort' => 'purchase_date', 'direction' => ($sort === 'purchase_date' && $direction === 'asc') ? 'desc' : 'asc'])); ?>" class="text-decoration-none text-dark">
                                <?php echo e(trans('messages.purchase_date')); ?>

                                <?php if($sort === 'purchase_date'): ?>
                                    <i class="bi bi-arrow-<?php echo e($direction === 'asc' ? 'up' : 'down'); ?>"></i>
                                <?php else: ?>
                                    <i class="bi bi-arrow-down-up text-muted"></i>
                                <?php endif; ?>
                            </a>
                        </th>
                        <th>
                            <a href="<?php echo e(request()->fullUrlWithQuery(['sort' => 'total_amount', 'direction' => ($sort === 'total_amount' && $direction === 'asc') ? 'desc' : 'asc'])); ?>" class="text-decoration-none text-dark">
                                <?php echo e(trans('messages.total_amount')); ?>

                                <?php if($sort === 'total_amount'): ?>
                                    <i class="bi bi-arrow-<?php echo e($direction === 'asc' ? 'up' : 'down'); ?>"></i>
                                <?php else: ?>
                                    <i class="bi bi-arrow-down-up text-muted"></i>
                                <?php endif; ?>
                            </a>
                        </th>
                        <th>
                            <a href="<?php echo e(request()->fullUrlWithQuery(['sort' => 'amount_paid', 'direction' => ($sort === 'amount_paid' && $direction === 'asc') ? 'desc' : 'asc'])); ?>" class="text-decoration-none text-dark">
                                <?php echo e(trans('messages.amount_paid')); ?>

                                <?php if($sort === 'amount_paid'): ?>
                                    <i class="bi bi-arrow-<?php echo e($direction === 'asc' ? 'up' : 'down'); ?>"></i>
                                <?php else: ?>
                                    <i class="bi bi-arrow-down-up text-muted"></i>
                                <?php endif; ?>
                            </a>
                        </th>
                        <th>
                            <a href="<?php echo e(request()->fullUrlWithQuery(['sort' => 'amount_remaining', 'direction' => ($sort === 'amount_remaining' && $direction === 'asc') ? 'desc' : 'asc'])); ?>" class="text-decoration-none text-dark">
                                <?php echo e(trans('messages.amount_remaining')); ?>

                                <?php if($sort === 'amount_remaining'): ?>
                                    <i class="bi bi-arrow-<?php echo e($direction === 'asc' ? 'up' : 'down'); ?>"></i>
                                <?php else: ?>
                                    <i class="bi bi-arrow-down-up text-muted"></i>
                                <?php endif; ?>
                            </a>
                        </th>
                        <th>
                            <a href="<?php echo e(request()->fullUrlWithQuery(['sort' => 'status', 'direction' => ($sort === 'status' && $direction === 'asc') ? 'desc' : 'asc'])); ?>" class="text-decoration-none text-dark">
                                <?php echo e(trans('messages.status')); ?>

                                <?php if($sort === 'status'): ?>
                                    <i class="bi bi-arrow-<?php echo e($direction === 'asc' ? 'up' : 'down'); ?>"></i>
                                <?php else: ?>
                                    <i class="bi bi-arrow-down-up text-muted"></i>
                                <?php endif; ?>
                            </a>
                        </th>
                        <th><?php echo e(trans('messages.actions')); ?></th>
                    </tr>
                </thead>
                <tbody>
                    <?php $__empty_1 = true; $__currentLoopData = $invoices; $__env->addLoop($__currentLoopData); foreach($__currentLoopData as $invoice): $__env->incrementLoopIndices(); $loop = $__env->getLastLoop(); $__empty_1 = false; ?>
                    <tr>
                        <?php if (app(\Illuminate\Contracts\Auth\Access\Gate::class)->check('purchase-invoices.bulk_delete')): ?>
                        <td>
                            <input type="checkbox" class="item-checkbox" value="<?php echo e($invoice->id); ?>">
                        </td>
                        <?php endif; ?>
                        <td><a href="<?php echo e(route('purchase-invoices.show', $invoice)); ?>"><?php echo e($invoice->invoice_number); ?></a></td>
                        <td><?php echo e($invoice->supplier->name); ?></td>
                        <td><?php echo e($invoice->purchase_date->format('Y-m-d')); ?></td>
                        <td><?php echo e(format_currency($invoice->total_amount)); ?></td>
                        <td><?php echo e(format_currency($invoice->amount_paid)); ?></td>
                        <td><span class="badge bg-<?php echo e($invoice->amount_remaining > 0 ? 'warning' : 'success'); ?>"><?php echo e(format_currency($invoice->amount_remaining)); ?></span></td>
                        <td>
                            <?php
                                $badgeClass = match($invoice->status) {
                                    'paid' => 'success',
                                    'partially_paid' => 'warning',
                                    'draft' => 'secondary',
                                    'returned' => 'danger',
                                    'confirmed' => 'info',
                                    default => 'warning'
                                };
                            ?>
                            <span class="badge bg-<?php echo e($badgeClass); ?>"><?php echo e(trans('messages.' . $invoice->status)); ?></span>
                        </td>
                        <td>
                            <?php if (app(\Illuminate\Contracts\Auth\Access\Gate::class)->check('purchase-invoices.view')): ?>
                                <a href="<?php echo e(route('purchase-invoices.show', $invoice)); ?>" class="btn btn-sm btn-info" title="<?php echo e(trans('messages.view')); ?>"><i class="bi bi-eye"></i></a>
                            <?php endif; ?>
                            <?php if (app(\Illuminate\Contracts\Auth\Access\Gate::class)->check('purchase-invoices.update')): ?>
                                <?php if($invoice->isDraft()): ?>
                                    <a href="<?php echo e(route('purchase-invoices.edit', $invoice)); ?>" class="btn btn-sm btn-warning" title="<?php echo e(trans('messages.edit')); ?>"><i class="bi bi-pencil"></i></a>
                                <?php endif; ?>
                            <?php endif; ?>
                            <?php if (app(\Illuminate\Contracts\Auth\Access\Gate::class)->check('purchase-invoices.delete')): ?>
                                <button type="button" class="btn btn-sm btn-danger" data-bs-toggle="modal" data-bs-target="#deletePurchaseInvoiceModal<?php echo e($invoice->id); ?>" title="<?php echo e(trans('messages.delete')); ?>">
                                    <i class="bi bi-trash"></i>
                                </button>
                            <?php endif; ?>
                        </td>
                    </tr>
                    <?php endforeach; $__env->popLoop(); $loop = $__env->getLastLoop(); if ($__empty_1): ?>
                    <tr>
                        <td colspan="<?php echo e(auth()->user()->can('purchase-invoices.bulk_delete') ? '9' : '8'); ?>" class="text-center"><?php echo e(trans('messages.no_purchase_invoices_found')); ?></td>
                    </tr>
                    <?php endif; ?>
                </tbody>
            </table>
        </div>
        </form>

        <?php echo e($invoices->links()); ?>

    </div>
</div>

<?php echo $__env->make('partials.bulk-delete-modal', \Illuminate\Support\Arr::except(get_defined_vars(), ['__data', '__path']))->render(); ?>

<?php if(auth()->user()->hasAnyRole(['Admin', 'Super Admin'])): ?>
<?php $__currentLoopData = $invoices; $__env->addLoop($__currentLoopData); foreach($__currentLoopData as $invoice): $__env->incrementLoopIndices(); $loop = $__env->getLastLoop(); ?>
<!-- Delete Confirmation Modal for Invoice <?php echo e($invoice->id); ?> -->
<div class="modal fade" id="deletePurchaseInvoiceModal<?php echo e($invoice->id); ?>" tabindex="-1" aria-labelledby="deletePurchaseInvoiceModalLabel<?php echo e($invoice->id); ?>" aria-hidden="true">
    <div class="modal-dialog">
        <div class="modal-content">
            <div class="modal-header">
                <h5 class="modal-title" id="deletePurchaseInvoiceModalLabel<?php echo e($invoice->id); ?>"><?php echo e(trans('messages.confirm_delete')); ?></h5>
                <button type="button" class="btn-close" data-bs-dismiss="modal" aria-label="Close"></button>
            </div>
            <div class="modal-body">
                <p><?php echo e(trans('messages.confirm_delete_purchase_invoice')); ?></p>
                <p><strong><?php echo e(trans('messages.invoice_number')); ?>:</strong> <?php echo e($invoice->invoice_number); ?></p>
                <?php if(!$invoice->isReturned() && ($invoice->isConfirmed() || $invoice->status === 'paid' || $invoice->status === 'partially_paid')): ?>
                    <div class="alert alert-warning">
                        <i class="bi bi-exclamation-triangle"></i> <?php echo e(trans('messages.stock_will_be_reversed')); ?>

                    </div>
                <?php endif; ?>
            </div>
            <div class="modal-footer">
                <button type="button" class="btn btn-secondary" data-bs-dismiss="modal"><?php echo e(trans('messages.cancel')); ?></button>
                <form action="<?php echo e(route('purchase-invoices.destroy', $invoice)); ?>" method="POST" class="d-inline">
                    <?php echo csrf_field(); ?>
                    <?php echo method_field('DELETE'); ?>
                    <button type="submit" class="btn btn-danger"><?php echo e(trans('messages.delete')); ?></button>
                </form>
            </div>
        </div>
    </div>
</div>
<?php endforeach; $__env->popLoop(); $loop = $__env->getLastLoop(); ?>
<?php endif; ?>
<?php $__env->stopSection(); ?>


<?php echo $__env->make('layouts.master', \Illuminate\Support\Arr::except(get_defined_vars(), ['__data', '__path']))->render(); ?><?php /**PATH C:\xampp\htdocs\GestionStock\resources\views/purchase-invoices/index.blade.php ENDPATH**/ ?>