

<?php $__env->startSection('title', trans('messages.treasury_dashboard')); ?>

<?php $__env->startSection('content'); ?>
<div class="page-header">
    <h2><?php echo e(trans('messages.treasury_dashboard')); ?></h2>
    <div>
        <a href="<?php echo e(route('treasury.index')); ?>" class="btn btn-primary"><i class="bi bi-list"></i> <?php echo e(trans('messages.all_movements')); ?></a>
        <?php if(auth()->user()->hasAnyRole(['Super Admin', 'Admin'])): ?>
            <a href="<?php echo e(route('treasury.create')); ?>" class="btn btn-success"><i class="bi bi-plus-circle"></i> <?php echo e(trans('messages.add_transaction')); ?></a>
        <?php endif; ?>
    </div>
</div>

<!-- Filters -->
<div class="card mb-3">
    <div class="card-body">
        <form method="GET" action="<?php echo e(route('treasury.dashboard')); ?>" class="row g-3">
            <div class="col-md-3">
                <label for="start_date" class="form-label"><?php echo e(trans('messages.start_date')); ?></label>
                <input type="date" class="form-control" id="start_date" name="start_date" value="<?php echo e($startDate); ?>">
            </div>
            <div class="col-md-3">
                <label for="end_date" class="form-label"><?php echo e(trans('messages.end_date')); ?></label>
                <input type="date" class="form-control" id="end_date" name="end_date" value="<?php echo e($endDate); ?>">
            </div>
            <div class="col-md-2">
                <label for="type" class="form-label"><?php echo e(trans('messages.type')); ?></label>
                <select class="form-select" id="type" name="type">
                    <option value=""><?php echo e(trans('messages.all')); ?></option>
                    <option value="income" <?php echo e($type === 'income' ? 'selected' : ''); ?>><?php echo e(trans('messages.income')); ?></option>
                    <option value="expense" <?php echo e($type === 'expense' ? 'selected' : ''); ?>><?php echo e(trans('messages.expense')); ?></option>
                </select>
            </div>
            <div class="col-md-2">
                <label for="payment_method" class="form-label"><?php echo e(trans('messages.payment_method')); ?></label>
                <select class="form-select" id="payment_method" name="payment_method">
                    <option value=""><?php echo e(trans('messages.all')); ?></option>
                    <option value="cash" <?php echo e($paymentMethod === 'cash' ? 'selected' : ''); ?>><?php echo e(trans('messages.cash')); ?></option>
                    <option value="card" <?php echo e($paymentMethod === 'card' ? 'selected' : ''); ?>><?php echo e(trans('messages.card')); ?></option>
                    <option value="bank" <?php echo e($paymentMethod === 'bank' ? 'selected' : ''); ?>><?php echo e(trans('messages.bank')); ?></option>
                    <option value="other" <?php echo e($paymentMethod === 'other' ? 'selected' : ''); ?>><?php echo e(trans('messages.other')); ?></option>
                </select>
            </div>
            <div class="col-md-2 d-flex align-items-end">
                <button type="submit" class="btn btn-secondary w-100"><?php echo e(trans('messages.filter')); ?></button>
            </div>
        </form>
    </div>
</div>

<!-- Summary Cards -->
<div class="row mb-4">
    <div class="col-md-4">
        <div class="card text-white bg-success">
            <div class="card-body">
                <h5 class="card-title"><?php echo e(trans('messages.total_cash_in')); ?></h5>
                <h2 class="mb-0"><?php echo e(format_currency($totalIncome)); ?></h2>
            </div>
        </div>
    </div>
    <div class="col-md-4">
        <div class="card text-white bg-danger">
            <div class="card-body">
                <h5 class="card-title"><?php echo e(trans('messages.total_cash_out')); ?></h5>
                <h2 class="mb-0"><?php echo e(format_currency($totalExpense)); ?></h2>
            </div>
        </div>
    </div>
    <div class="col-md-4">
        <div class="card text-white <?php echo e($currentBalance >= 0 ? 'bg-primary' : 'bg-warning'); ?>">
            <div class="card-body">
                <h5 class="card-title"><?php echo e(trans('messages.current_cash_balance')); ?></h5>
                <h2 class="mb-0"><?php echo e(format_currency($currentBalance)); ?></h2>
            </div>
        </div>
    </div>
</div>

<!-- Today's Movements -->
<div class="card">
    <div class="card-header">
        <h5 class="mb-0"><?php echo e(trans('messages.todays_cash_movements')); ?></h5>
    </div>
    <div class="card-body">
        <?php if($todayMovements->count() > 0): ?>
            <div class="table-responsive">
                <table class="table table-hover">
                    <thead>
                        <tr>
                            <th><?php echo e(trans('messages.date')); ?></th>
                            <th><?php echo e(trans('messages.type')); ?></th>
                            <th><?php echo e(trans('messages.reference_type')); ?></th>
                            <th><?php echo e(trans('messages.amount')); ?></th>
                            <th><?php echo e(trans('messages.payment_method')); ?></th>
                            <th><?php echo e(trans('messages.description')); ?></th>
                            <th><?php echo e(trans('messages.created_by')); ?></th>
                            <?php if(auth()->user()->hasAnyRole(['Super Admin', 'Admin'])): ?>
                            <th><?php echo e(trans('messages.actions')); ?></th>
                            <?php endif; ?>
                        </tr>
                    </thead>
                    <tbody>
                        <?php $__currentLoopData = $todayMovements; $__env->addLoop($__currentLoopData); foreach($__currentLoopData as $movement): $__env->incrementLoopIndices(); $loop = $__env->getLastLoop(); ?>
                        <tr>
                            <td><?php echo e($movement->date ? \Carbon\Carbon::parse($movement->date)->format('Y-m-d') : '-'); ?></td>
                            <td>
                                <span class="badge <?php echo e($movement->type === 'income' ? 'bg-success' : 'bg-danger'); ?>">
                                    <?php echo e(trans('messages.' . $movement->type)); ?>

                                </span>
                            </td>
                            <td><?php echo e(trans('messages.' . $movement->reference_type)); ?></td>
                            <td><?php echo e(format_currency($movement->amount)); ?></td>
                            <td><?php echo e(trans('messages.' . $movement->payment_method)); ?></td>
                            <td><?php echo e($movement->description ?? '-'); ?></td>
                            <td><?php echo e($movement->creator->name ?? '-'); ?></td>
                            <?php if(auth()->user()->hasAnyRole(['Super Admin', 'Admin'])): ?>
                            <td>
                                <a href="<?php echo e(route('treasury.show', $movement)); ?>" class="btn btn-sm btn-info" title="<?php echo e(trans('messages.view')); ?>"><i class="bi bi-eye"></i></a>
                                <a href="<?php echo e(route('treasury.edit', $movement)); ?>" class="btn btn-sm btn-warning" title="<?php echo e(trans('messages.edit')); ?>"><i class="bi bi-pencil"></i></a>
                                <form action="<?php echo e(route('treasury.destroy', $movement)); ?>" method="POST" class="d-inline delete-form">
                                    <?php echo csrf_field(); ?>
                                    <?php echo method_field('DELETE'); ?>
                                    <button type="submit" class="btn btn-sm btn-danger" title="<?php echo e(trans('messages.delete')); ?>" onclick="event.preventDefault(); confirmAction('<?php echo e(trans('messages.confirm_delete')); ?>', '<?php echo e(trans('messages.confirm_delete')); ?>', () => this.closest('form').submit()); return false;"><i class="bi bi-trash"></i></button>
                                </form>
                            </td>
                            <?php endif; ?>
                        </tr>
                        <?php endforeach; $__env->popLoop(); $loop = $__env->getLastLoop(); ?>
                    </tbody>
                </table>
            </div>
        <?php else: ?>
            <p class="text-muted"><?php echo e(trans('messages.no_data')); ?></p>
        <?php endif; ?>
    </div>
</div>
<?php $__env->stopSection(); ?>


<?php echo $__env->make('layouts.master', \Illuminate\Support\Arr::except(get_defined_vars(), ['__data', '__path']))->render(); ?><?php /**PATH C:\xampp\htdocs\GestionStock\resources\views/treasury/dashboard.blade.php ENDPATH**/ ?>