<?php
    $currentLocale = app()->getLocale();
    $locales = [
        'en' => ['name' => 'English', 'flag' => 'gb'],
        'ar' => ['name' => 'العربية', 'flag' => 'ma'],
        'fr' => ['name' => 'Français', 'flag' => 'fr'],
    ];
    $storeName = \App\Models\Setting::get('store_name', 'Gestock Pro');
?>
<nav class="navbar navbar-expand-lg navbar-dark bg-primary">
    <div class="container-fluid">
        <button class="sidebar-toggle d-lg-none" type="button" id="sidebarToggleBtn" aria-label="Toggle sidebar">
            <i class="bi bi-list"></i>
        </button>
        <a class="navbar-brand" href="<?php echo e(route('dashboard')); ?>">
            <i class="bi bi-box-seam"></i> <span class="d-none d-sm-inline">Gestock Pro</span>
        </a>
        <button class="navbar-toggler" type="button" data-bs-toggle="collapse" data-bs-target="#navbarNav" aria-controls="navbarNav" aria-expanded="false" aria-label="Toggle navigation">
            <span class="navbar-toggler-icon"></span>
        </button>
        <div class="collapse navbar-collapse" id="navbarNav">
            <ul class="navbar-nav ms-auto">
                <?php if(auth()->check() && (auth()->user()->hasRole('Super Admin') || auth()->user()->hasRole('Admin'))): ?>
                <!-- Treasury Balance Widget -->
                <li class="nav-item me-2">
                    <?php
                        $treasuryBalance = \App\Http\Controllers\TreasuryController::getCurrentBalance();
                    ?>
                    <span class="nav-link text-white" style="font-weight: bold; background-color: <?php echo e($treasuryBalance >= 0 ? 'rgba(40, 167, 69, 0.3)' : 'rgba(220, 53, 69, 0.3)'); ?>; border-radius: 5px; padding: 5px 10px; border: 1px solid <?php echo e($treasuryBalance >= 0 ? 'rgba(40, 167, 69, 0.5)' : 'rgba(220, 53, 69, 0.5)'); ?>;">
                        <i class="bi bi-cash-coin"></i> <?php echo e(trans('messages.current_cash_balance')); ?>: <?php echo e(format_currency($treasuryBalance)); ?>

                    </span>
                </li>
                <?php endif; ?>
                <!-- Language Switcher -->
                <li class="nav-item dropdown me-2">
                    <a class="nav-link dropdown-toggle" href="#" id="languageDropdown" role="button" data-bs-toggle="dropdown">
                        <i class="bi bi-translate"></i> <span class="fi fi-<?php echo e($locales[$currentLocale]['flag']); ?>"></span> <?php echo e($locales[$currentLocale]['name']); ?>

                    </a>
                    <ul class="dropdown-menu dropdown-menu-end">
                        <?php $__currentLoopData = $locales; $__env->addLoop($__currentLoopData); foreach($__currentLoopData as $code => $locale): $__env->incrementLoopIndices(); $loop = $__env->getLastLoop(); ?>
                            <?php if($code !== $currentLocale): ?>
                                <li>
                                    <a class="dropdown-item" href="<?php echo e(route('language.switch', $code)); ?>">
                                        <span class="fi fi-<?php echo e($locale['flag']); ?>"></span> <?php echo e($locale['name']); ?>

                                    </a>
                                </li>
                            <?php endif; ?>
                        <?php endforeach; $__env->popLoop(); $loop = $__env->getLastLoop(); ?>
                    </ul>
                </li>
                <!-- User Menu -->
                <li class="nav-item dropdown">
                    <a class="nav-link dropdown-toggle" href="#" id="navbarDropdown" role="button" data-bs-toggle="dropdown">
                        <i class="bi bi-person-circle"></i> <?php echo e(Auth::user()->name); ?>

                    </a>
                    <ul class="dropdown-menu dropdown-menu-end">
                        <li><a class="dropdown-item" href="<?php echo e(route('profile.settings')); ?>"><i class="bi bi-person"></i> <?php echo e(__('messages.profile_settings')); ?></a></li>
                        <li><a class="dropdown-item" href="<?php echo e(route('settings.index')); ?>"><i class="bi bi-gear"></i> <?php echo e(__('messages.settings')); ?></a></li>
                        <li><hr class="dropdown-divider"></li>
                        <li>
                            <form method="POST" action="<?php echo e(route('logout')); ?>">
                                <?php echo csrf_field(); ?>
                                <button type="submit" class="dropdown-item">
                                    <i class="bi bi-box-arrow-right"></i> <?php echo e(__('messages.logout')); ?>

                                </button>
                            </form>
                        </li>
                    </ul>
                </li>
            </ul>
        </div>
    </div>
</nav>
<?php /**PATH C:\xampp\htdocs\GestionStock\resources\views/layouts/partials/navbar.blade.php ENDPATH**/ ?>