

<?php $__env->startSection('title', trans('messages.product_defects')); ?>

<?php $__env->startSection('content'); ?>
<?php
    $sort = request()->get('sort', 'created_at');
    $direction = request()->get('direction', 'desc');
?>
<div class="page-header">
    <h2><?php echo e(trans('messages.product_defects')); ?></h2>
    <div>
        <?php if (app(\Illuminate\Contracts\Auth\Access\Gate::class)->check('quality.defects.create')): ?>
            <a href="<?php echo e(route('quality.defects.create')); ?>" class="btn btn-primary"><i class="bi bi-plus-circle"></i> <?php echo e(trans('messages.add_defect')); ?></a>
        <?php endif; ?>
    </div>
</div>

<div class="card">
    <div class="card-body">
        <form method="GET" action="<?php echo e(route('quality.defects.index')); ?>" class="mb-3">
            <div class="row g-3">
                <div class="col-md-3">
                    <input type="text" name="search" class="form-control" placeholder="<?php echo e(trans('messages.search')); ?>..." value="<?php echo e(request('search')); ?>">
                </div>
                <div class="col-md-2">
                    <select name="status" class="form-select">
                        <option value=""><?php echo e(trans('messages.all_statuses')); ?></option>
                        <option value="reported" <?php echo e(request('status') == 'reported' ? 'selected' : ''); ?>><?php echo e(trans('messages.reported')); ?></option>
                        <option value="under_review" <?php echo e(request('status') == 'under_review' ? 'selected' : ''); ?>><?php echo e(trans('messages.under_review')); ?></option>
                        <option value="resolved" <?php echo e(request('status') == 'resolved' ? 'selected' : ''); ?>><?php echo e(trans('messages.resolved')); ?></option>
                        <option value="rejected" <?php echo e(request('status') == 'rejected' ? 'selected' : ''); ?>><?php echo e(trans('messages.rejected')); ?></option>
                    </select>
                </div>
                <div class="col-md-2">
                    <select name="severity" class="form-select">
                        <option value=""><?php echo e(trans('messages.all_severities')); ?></option>
                        <option value="low" <?php echo e(request('severity') == 'low' ? 'selected' : ''); ?>><?php echo e(trans('messages.low')); ?></option>
                        <option value="medium" <?php echo e(request('severity') == 'medium' ? 'selected' : ''); ?>><?php echo e(trans('messages.medium')); ?></option>
                        <option value="high" <?php echo e(request('severity') == 'high' ? 'selected' : ''); ?>><?php echo e(trans('messages.high')); ?></option>
                        <option value="critical" <?php echo e(request('severity') == 'critical' ? 'selected' : ''); ?>><?php echo e(trans('messages.critical')); ?></option>
                    </select>
                </div>
                <div class="col-md-2">
                    <select name="product_id" class="form-select">
                        <option value=""><?php echo e(trans('messages.all_products')); ?></option>
                        <?php $__currentLoopData = $products; $__env->addLoop($__currentLoopData); foreach($__currentLoopData as $product): $__env->incrementLoopIndices(); $loop = $__env->getLastLoop(); ?>
                            <option value="<?php echo e($product->id); ?>" <?php echo e(request('product_id') == $product->id ? 'selected' : ''); ?>><?php echo e($product->name); ?></option>
                        <?php endforeach; $__env->popLoop(); $loop = $__env->getLastLoop(); ?>
                    </select>
                </div>
                <div class="col-md-3">
                    <button type="submit" class="btn btn-secondary w-100"><?php echo e(trans('messages.filter')); ?></button>
                </div>
            </div>
        </form>

        <div class="table-responsive">
            <table class="table table-hover">
                <thead>
                    <tr>
                        <th>
                            <a href="<?php echo e(route('quality.defects.index', array_merge(request()->all(), ['sort' => 'defect_number', 'direction' => $sort === 'defect_number' && $direction === 'asc' ? 'desc' : 'asc']))); ?>" class="text-decoration-none text-dark">
                                <?php echo e(trans('messages.defect_number')); ?>

                                <?php if($sort === 'defect_number'): ?>
                                    <i class="bi bi-arrow-<?php echo e($direction === 'asc' ? 'up' : 'down'); ?>"></i>
                                <?php endif; ?>
                            </a>
                        </th>
                        <th><?php echo e(trans('messages.product')); ?></th>
                        <th><?php echo e(trans('messages.defect_type')); ?></th>
                        <th><?php echo e(trans('messages.severity')); ?></th>
                        <th><?php echo e(trans('messages.quantity')); ?></th>
                        <th>
                            <a href="<?php echo e(route('quality.defects.index', array_merge(request()->all(), ['sort' => 'reported_date', 'direction' => $sort === 'reported_date' && $direction === 'asc' ? 'desc' : 'asc']))); ?>" class="text-decoration-none text-dark">
                                <?php echo e(trans('messages.reported_date')); ?>

                                <?php if($sort === 'reported_date'): ?>
                                    <i class="bi bi-arrow-<?php echo e($direction === 'asc' ? 'up' : 'down'); ?>"></i>
                                <?php endif; ?>
                            </a>
                        </th>
                        <th>
                            <a href="<?php echo e(route('quality.defects.index', array_merge(request()->all(), ['sort' => 'status', 'direction' => $sort === 'status' && $direction === 'asc' ? 'desc' : 'asc']))); ?>" class="text-decoration-none text-dark">
                                <?php echo e(trans('messages.status')); ?>

                                <?php if($sort === 'status'): ?>
                                    <i class="bi bi-arrow-<?php echo e($direction === 'asc' ? 'up' : 'down'); ?>"></i>
                                <?php endif; ?>
                            </a>
                        </th>
                        <th><?php echo e(trans('messages.assigned_to')); ?></th>
                        <th><?php echo e(trans('messages.actions')); ?></th>
                    </tr>
                </thead>
                <tbody>
                    <?php $__empty_1 = true; $__currentLoopData = $defects; $__env->addLoop($__currentLoopData); foreach($__currentLoopData as $defect): $__env->incrementLoopIndices(); $loop = $__env->getLastLoop(); $__empty_1 = false; ?>
                    <tr>
                        <td><strong><?php echo e($defect->defect_number); ?></strong></td>
                        <td>
                            <a href="<?php echo e(route('products.show', $defect->product)); ?>"><?php echo e($defect->product->name); ?></a>
                        </td>
                        <td><?php echo e(trans('messages.defect_type_' . $defect->defect_type)); ?></td>
                        <td>
                            <span class="badge bg-<?php echo e($defect->getSeverityBadgeClass()); ?>">
                                <?php echo e(trans('messages.severity_' . $defect->severity)); ?>

                            </span>
                        </td>
                        <td><?php echo e(number_format($defect->quantity)); ?></td>
                        <td><?php echo e($defect->reported_date->format('Y-m-d')); ?></td>
                        <td>
                            <span class="badge bg-<?php echo e($defect->getStatusBadgeClass()); ?>">
                                <?php echo e(trans('messages.status_' . $defect->status)); ?>

                            </span>
                        </td>
                        <td><?php echo e($defect->assignedTo?->name ?? '-'); ?></td>
                        <td>
                            <a href="<?php echo e(route('quality.defects.show', $defect)); ?>" class="btn btn-sm btn-info">
                                <i class="bi bi-eye"></i>
                            </a>
                            <?php if (app(\Illuminate\Contracts\Auth\Access\Gate::class)->check('quality.defects.update')): ?>
                                <a href="<?php echo e(route('quality.defects.edit', $defect)); ?>" class="btn btn-sm btn-warning">
                                    <i class="bi bi-pencil"></i>
                                </a>
                            <?php endif; ?>
                            <?php if (app(\Illuminate\Contracts\Auth\Access\Gate::class)->check('quality.defects.delete')): ?>
                                <form action="<?php echo e(route('quality.defects.destroy', $defect)); ?>" method="POST" class="d-inline" onsubmit="return confirm('<?php echo e(trans('messages.confirm_delete_defect')); ?>')">
                                    <?php echo csrf_field(); ?>
                                    <?php echo method_field('DELETE'); ?>
                                    <button type="submit" class="btn btn-sm btn-danger">
                                        <i class="bi bi-trash"></i>
                                    </button>
                                </form>
                            <?php endif; ?>
                        </td>
                    </tr>
                    <?php endforeach; $__env->popLoop(); $loop = $__env->getLastLoop(); if ($__empty_1): ?>
                    <tr>
                        <td colspan="9" class="text-center"><?php echo e(trans('messages.no_defects_found')); ?></td>
                    </tr>
                    <?php endif; ?>
                </tbody>
            </table>
        </div>

        <div class="card-footer">
            <?php echo e($defects->links()); ?>

        </div>
    </div>
</div>
<?php $__env->stopSection(); ?>


<?php echo $__env->make('layouts.master', \Illuminate\Support\Arr::except(get_defined_vars(), ['__data', '__path']))->render(); ?><?php /**PATH C:\xampp\htdocs\GestionStock\resources\views/quality/defects/index.blade.php ENDPATH**/ ?>