<?php

namespace Tests\Feature;

use App\Models\Product;
use App\Models\User;
use Illuminate\Foundation\Testing\RefreshDatabase;
use Tests\TestCase;

class ProductTest extends TestCase
{
    use RefreshDatabase;

    public function test_user_can_view_products_index(): void
    {
        $user = User::factory()->create();
        $user->assignRole('Admin');

        $response = $this->actingAs($user)->get('/products');

        $response->assertStatus(200);
    }

    public function test_user_can_create_product(): void
    {
        $user = User::factory()->create();
        $user->assignRole('Admin');

        $response = $this->actingAs($user)->post('/products', [
            'sku' => 'TEST001',
            'name' => 'Test Product',
            'unit' => 'piece',
            'purchase_price' => 10,
            'selling_price' => 15,
            'stock_quantity' => 100,
            'reorder_level' => 20,
        ]);

        $response->assertRedirect('/products');
        $this->assertDatabaseHas('products', ['sku' => 'TEST001']);
    }
}

